/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.injection.test.context;

import java.lang.reflect.Method;
import org.dreamcat.injection.test.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTestContext
implements TestContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultTestContext.class);
    private final Class<?> testClass;
    private volatile Object testInstance;
    private volatile Method testMethod;
    private volatile Throwable testException;

    @Override
    public final Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public TestContext copy() {
        DefaultTestContext context = new DefaultTestContext(this.testClass);
        context.testInstance = this.testInstance;
        context.testMethod = this.testMethod;
        context.testException = this.testException;
        return context;
    }

    @Override
    public final Object getTestInstance() {
        Object testInstance = this.testInstance;
        if (testInstance == null) {
            throw new IllegalStateException("No test instance");
        }
        return testInstance;
    }

    @Override
    public final Method getTestMethod() {
        Method testMethod = this.testMethod;
        if (testMethod == null) {
            throw new IllegalStateException("No test method");
        }
        return testMethod;
    }

    @Override
    public final Throwable getTestException() {
        return this.testException;
    }

    @Override
    public void updateState(Object testInstance, Method testMethod, Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    public DefaultTestContext(Class<?> testClass) {
        this.testClass = testClass;
    }
}

