/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.injection.test.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dreamcat.common.di.InjectionFactory;
import org.dreamcat.common.util.ObjectUtil;
import org.dreamcat.common.util.ReflectUtil;
import org.dreamcat.common.util.StringUtil;
import org.dreamcat.injection.test.context.TestContext;
import org.dreamcat.injection.test.context.TestExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class SpringBootTestExecutionListener
implements TestExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(SpringBootTestExecutionListener.class);
    private final InjectionFactory di;
    private static final Class javaxResourceClass = ReflectUtil.forNameOrNull((String)"javax.annotation.Resource");
    private static final Class javaxPostConstructClass = ReflectUtil.forNameOrNull((String)"javax.annotation.PostConstruct");
    private static final Class mockitoClass = ReflectUtil.forNameOrNull((String)"org.mockito.Mockito");
    private static final Class mockClass = ReflectUtil.forNameOrNull((String)"org.mockito.Mock");
    private static final Class spyClass = ReflectUtil.forNameOrNull((String)"org.mockito.Spy");
    private static final Class springMockBeanClass = ReflectUtil.forNameOrNull((String)"org.springframework.boot.test.mock.mockito.MockBean");
    private static final Class springSpyBeanClass = ReflectUtil.forNameOrNull((String)"org.springframework.boot.test.mock.mockito.SpyBean");
    private static final Class springRestControllerClass = ReflectUtil.forNameOrNull((String)"org.springframework.web.bind.annotation.RestController");
    private static final Function<Object, String> nameGetter = ann -> (String)ReflectUtil.invoke((Object)ann, (String)"name", (Object[])new Object[0]);
    private static final Function<Object, String> valueGetter = ann -> (String)ReflectUtil.invoke((Object)ann, (String)"value", (Object[])new Object[0]);
    private static final Function<Object, String> emptyNameGetter = ann -> "";
    private static final Pattern generatedClassName1 = Pattern.compile("^.*?\\$.*?\\$\\d+$");
    private static final Pattern generatedClassName2 = Pattern.compile("^.*?\\$\\$.*?$");

    public static TestExecutionListener resolve(Class<?> testClass) throws Exception {
        SpringBootApplication sba = (SpringBootApplication)ReflectUtil.retrieveAnnotation(testClass, SpringBootApplication.class);
        ComponentScan cs = (ComponentScan)ReflectUtil.retrieveAnnotation(testClass, ComponentScan.class);
        if (sba == null && cs == null) {
            return null;
        }
        return new SpringBootTestExecutionListener(testClass, sba, cs);
    }

    private SpringBootTestExecutionListener(Class<?> testClass, SpringBootApplication sba, ComponentScan cs) throws Exception {
        Object[] basePackageClasses;
        Object[] basePackages;
        if (sba != null) {
            basePackages = sba.scanBasePackages();
            basePackageClasses = sba.scanBasePackageClasses();
        } else {
            basePackages = cs.basePackages();
            basePackageClasses = cs.basePackageClasses();
        }
        HashSet<String> basePackageSet = new HashSet<String>();
        if (ObjectUtil.isNotEmpty((Object[])basePackages)) {
            Collections.addAll(basePackageSet, basePackages);
        } else if (ObjectUtil.isNotEmpty((Object[])basePackageClasses)) {
            for (Object basePackageClass : basePackageClasses) {
                basePackageSet.add(((Class)basePackageClass).getPackage().getName());
            }
        } else {
            basePackageSet.add(testClass.getPackage().getName());
        }
        InjectionFactory.Builder builder = InjectionFactory.builder().disableFailOnThrow().basePackage(basePackageSet).addResourceMapping(Component.class, Component::value).addResourceMapping(Service.class, Service::value).addResourceMapping(Bean.class, it -> it.name().length > 0 ? it.name()[0] : "").addInjectMapping(Qualifier.class, Qualifier::value).addInjectMapping(Autowired.class, emptyNameGetter);
        boolean enableSimpleConvention = StringUtil.isTrueString((String)EnvOrProperty.INJECTION_TEST_ENABLE_SIMPLE_CONVENTION.get());
        if (!enableSimpleConvention) {
            builder.addResourceMapping(Configuration.class, Configuration::value).addResourceMapping(Repository.class, Repository::value).addResourceMapping(Controller.class, Controller::value).addResourceMapping(SpringBootApplication.class, emptyNameGetter);
            if (springRestControllerClass != null) {
                builder.addResourceMapping(springRestControllerClass, valueGetter);
            }
        }
        if (javaxResourceClass != null) {
            builder.addInjectMapping(javaxResourceClass, nameGetter);
            builder.addPostConstruct(javaxPostConstructClass);
        }
        if (springMockBeanClass != null && springSpyBeanClass != null && mockitoClass != null) {
            builder.addMockInjectMapping(springMockBeanClass, nameGetter, this::mock);
            builder.addSpyInjectMapping(springSpyBeanClass, nameGetter, this::spy);
        }
        if (mockitoClass != null) {
            builder.addMockInjectMapping(mockClass, nameGetter, this::mock);
            builder.addSpyInjectMapping(spyClass, emptyNameGetter, this::spy);
        }
        this.configIgnorePredicate(builder);
        this.di = builder.build();
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        Class<?> testClass = testContext.getTestClass();
        Object testInstance = testContext.getTestInstance();
        try {
            this.di.resolveMockBeans(testClass, testInstance);
            this.di.refreshConstruct();
            this.di.resolveFields(testClass, testInstance);
            this.di.resolveSpyBeans(testClass, testInstance);
            this.di.refreshPostConstruct();
        }
        catch (Exception e) {
            log.error("di failed for injection test: " + e.getMessage(), (Throwable)e);
        }
    }

    private Object mock(Class<?> clazz) {
        Method method = mockitoClass.getDeclaredMethod("mock", Class.class);
        return method.invoke(null, clazz);
    }

    private Object spy(Object value) {
        Method method = mockitoClass.getDeclaredMethod("spy", Object.class);
        return method.invoke(null, value);
    }

    private void configIgnorePredicate(InjectionFactory.Builder builder) {
        String enableSimpleConvention;
        ArrayList<Predicate<Class>> ignorePredicates = new ArrayList<Predicate<Class>>();
        String ignoreClassPatterns = EnvOrProperty.INJECTION_TEST_IGNORE_CLASS_PATTERNS.get();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (StringUtil.isNotEmpty((CharSequence)ignoreClassPatterns)) {
            patterns.addAll(Arrays.stream(ignoreClassPatterns.split(",")).filter(StringUtil::isNotEmpty).map(Pattern::compile).collect(Collectors.toList()));
        }
        if (StringUtil.isTrueString((String)(enableSimpleConvention = EnvOrProperty.INJECTION_TEST_ENABLE_SIMPLE_CONVENTION.get()))) {
            patterns.add(generatedClassName1);
            patterns.add(generatedClassName2);
        }
        if (!patterns.isEmpty()) {
            ignorePredicates.add(clazz -> {
                String name = clazz.getName();
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(name).matches()) continue;
                    return true;
                }
                return false;
            });
        }
        if (!ignorePredicates.isEmpty()) {
            builder.ignorePredicate(clazz -> {
                for (Predicate ignorePredicate : ignorePredicates) {
                    if (!ignorePredicate.test(clazz)) continue;
                    return true;
                }
                return false;
            });
        }
    }

    private SpringBootTestExecutionListener(InjectionFactory di) {
        this.di = di;
    }

    static enum EnvOrProperty {
        INJECTION_TEST_ENABLE_SIMPLE_CONVENTION("org.dreamcat.injection.test.enable_simple_convention"),
        INJECTION_TEST_IGNORE_CLASS_PATTERNS("org.dreamcat.injection.test.ignore_class_patterns");

        private final String propertyName;

        public String get() {
            String v = System.getenv(this.name());
            if (StringUtil.isNotEmpty((CharSequence)v)) {
                return v;
            }
            return System.getProperty(this.propertyName);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        private EnvOrProperty(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

