/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.callback;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.core.IExcelWriteCallback;

public class FitWidthWriteCallback
implements IExcelWriteCallback {
    @Override
    public void onFinishCell(Workbook workbook, Sheet sheet, int sheetIndex, Row row, Cell cell, IExcelContent content, CellStyle style) {
        int columnIndex;
        int columnWith;
        int charNum;
        int width;
        double px = 1.0;
        if (style != null) {
            int fontIndex = style.getFontIndex();
            int fontNum = workbook.getNumberOfFonts();
            if (fontIndex >= 0 && fontIndex < fontNum) {
                Font font = workbook.getFontAt(fontIndex);
                px = (double)font.getFontHeightInPoints() / 12.0;
            }
        }
        if ((width = (int)((double)(((charNum = content.toString().length()) + 1) * 256) * px)) > 65280) {
            width = 65280;
        }
        if (width > (columnWith = sheet.getColumnWidth(columnIndex = cell.getColumnIndex()))) {
            sheet.setColumnWidth(columnIndex, width);
        }
    }
}

