/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.content;

import org.apache.poi.ss.usermodel.Cell;
import org.dreamcat.jwrap.excel.content.IExcelContent;

public class ExcelNumericContent
implements IExcelContent {
    private double value;

    @Override
    public void fill(Cell cell) {
        cell.setCellValue(this.value);
    }

    public String toString() {
        long round = Math.round(this.value);
        if (this.value == (double)round) {
            return Long.toString(round);
        }
        return Double.toString(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelNumericContent)) {
            return false;
        }
        ExcelNumericContent other = (ExcelNumericContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelNumericContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    public ExcelNumericContent() {
    }

    public ExcelNumericContent(double value) {
        this.value = value;
    }
}

