/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.content;

import java.util.Arrays;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelPicture {
    private byte[] data;
    private int pictureType;
    private String contentType;

    public static ExcelPicture from(PictureData picture) {
        ExcelPicture excelPicture = new ExcelPicture();
        excelPicture.setData(picture.getData());
        excelPicture.setPictureType(picture.getPictureType());
        excelPicture.setContentType(picture.getMimeType());
        return excelPicture;
    }

    public <W extends Workbook> void fill(W workbook) {
        workbook.addPicture(this.data, this.pictureType);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setPictureType(int pictureType) {
        this.pictureType = pictureType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelPicture)) {
            return false;
        }
        ExcelPicture other = (ExcelPicture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        if (this.getPictureType() != other.getPictureType()) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelPicture;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getData());
        result = result * 59 + this.getPictureType();
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    public String toString() {
        return "ExcelPicture(data=" + Arrays.toString(this.getData()) + ", pictureType=" + this.getPictureType() + ", contentType=" + this.getContentType() + ")";
    }

    public ExcelPicture() {
    }

    public ExcelPicture(byte[] data, int pictureType, String contentType) {
        this.data = data;
        this.pictureType = pictureType;
        this.contentType = contentType;
    }
}

