/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.content;

import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.style.ExcelRichString;

public class ExcelStringContent
implements IExcelContent {
    private ExcelRichString value;

    @Override
    public void fill(Cell cell) {
        if (!this.value.hasFormatting()) {
            cell.setCellValue(this.value.getString());
            return;
        }
        String string = this.value.getString();
        Object richTextString = cell instanceof XSSFCell ? new XSSFRichTextString(string) : new HSSFRichTextString(string);
        this.value.fill((RichTextString)richTextString);
        cell.setCellValue((RichTextString)richTextString);
    }

    public String toString() {
        return this.value.getString();
    }

    public static ExcelStringContent from(String string) {
        ExcelRichString value = new ExcelRichString(string, null);
        return new ExcelStringContent(value);
    }

    public ExcelRichString getValue() {
        return this.value;
    }

    public void setValue(ExcelRichString value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelStringContent)) {
            return false;
        }
        ExcelStringContent other = (ExcelStringContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExcelRichString this$value = this.getValue();
        ExcelRichString other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelStringContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExcelRichString $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public ExcelStringContent() {
    }

    public ExcelStringContent(ExcelRichString value) {
        this.value = value;
    }
}

