/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.content;

import org.apache.poi.ss.usermodel.Cell;
import org.dreamcat.jwrap.excel.content.ExcelBooleanContent;
import org.dreamcat.jwrap.excel.content.ExcelNumericContent;
import org.dreamcat.jwrap.excel.content.ExcelStringContent;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.style.ExcelRichString;

public class ExcelUnionContent
implements IExcelContent {
    private final ExcelStringContent stringContent = new ExcelStringContent();
    private final ExcelNumericContent numericContent = new ExcelNumericContent();
    private final ExcelBooleanContent booleanContent = new ExcelBooleanContent();
    private IExcelContent rawContent;
    private Class type;

    protected ExcelUnionContent() {
    }

    public ExcelUnionContent(String value) {
        this();
        this.setStringContent(value);
    }

    public ExcelUnionContent(double value) {
        this();
        this.setNumericContent(value);
    }

    public ExcelUnionContent(boolean value) {
        this();
        this.setBooleanContent(value);
    }

    public ExcelUnionContent(Object value) {
        this();
        this.setContent(value);
    }

    public void setStringContent(String value) {
        this.stringContent.setValue(ExcelRichString.from(value));
        this.type = ExcelStringContent.class;
    }

    public void setNumericContent(double value) {
        this.numericContent.setValue(value);
        this.type = ExcelNumericContent.class;
    }

    public void setBooleanContent(boolean value) {
        this.booleanContent.setValue(value);
        this.type = ExcelBooleanContent.class;
    }

    public void setRawContent(IExcelContent rawContent) {
        this.rawContent = rawContent;
        this.type = IExcelContent.class;
    }

    public void setContent(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            this.setNumericContent(number.doubleValue());
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            this.setBooleanContent(bool);
        } else if (value instanceof IExcelContent) {
            this.setRawContent((IExcelContent)value);
        } else {
            this.setStringContent(value == null ? "" : value.toString());
        }
    }

    public String toString() {
        if (this.type.equals(ExcelStringContent.class)) {
            return this.stringContent.getValue().getString();
        }
        if (this.type.equals(ExcelNumericContent.class)) {
            return String.valueOf(this.numericContent.getValue());
        }
        if (this.type.equals(ExcelBooleanContent.class)) {
            return String.valueOf(this.booleanContent.isValue());
        }
        return this.rawContent.toString();
    }

    @Override
    public void fill(Cell cell) {
        if (this.type.equals(ExcelStringContent.class)) {
            this.stringContent.fill(cell);
        } else if (this.type.equals(ExcelNumericContent.class)) {
            this.numericContent.fill(cell);
        } else if (this.type.equals(ExcelBooleanContent.class)) {
            this.booleanContent.fill(cell);
        } else if (this.rawContent != null) {
            this.rawContent.fill(cell);
        }
    }
}

