/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.content;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.dreamcat.jwrap.excel.content.ExcelBooleanContent;
import org.dreamcat.jwrap.excel.content.ExcelFormulaContent;
import org.dreamcat.jwrap.excel.content.ExcelNumericContent;
import org.dreamcat.jwrap.excel.content.ExcelStringContent;
import org.dreamcat.jwrap.excel.style.ExcelRichString;

public interface IExcelContent {
    public static IExcelContent from(Cell cell) {
        CellType type = cell.getCellType();
        switch (type) {
            case STRING: {
                RichTextString richTextString = cell.getRichStringCellValue();
                return new ExcelStringContent(ExcelRichString.from(richTextString));
            }
            case NUMERIC: {
                return new ExcelNumericContent(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return new ExcelBooleanContent(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return new ExcelFormulaContent(cell.getCellFormula());
            }
        }
        return new ExcelStringContent();
    }

    public static Object valueOf(Cell cell) {
        CellType type = cell.getCellType();
        switch (type) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                double value = cell.getNumericCellValue();
                long round = Math.round(value);
                if (value == (double)round) {
                    return round;
                }
                return value;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
        }
        return "";
    }

    public void fill(Cell var1);
}

