/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.core;

import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.style.ExcelComment;
import org.dreamcat.jwrap.excel.style.ExcelHyperLink;
import org.dreamcat.jwrap.excel.style.ExcelStyle;

public class ExcelCell
implements IExcelCell {
    protected IExcelContent content;
    protected int rowIndex;
    protected int columnIndex;
    protected CellPart cellPart;

    public ExcelCell(IExcelContent content, int rowIndex, int columnIndex) {
        this.content = content;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
    }

    public ExcelCell(IExcelContent content, int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
        this.content = content;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        if (rowSpan > 1 || columnSpan > 1) {
            this.cellPart = new CellPart(rowSpan, columnSpan);
        }
    }

    @Override
    public int getRowSpan() {
        return this.cellPart != null ? this.cellPart.rowSpan : 1;
    }

    @Override
    public void setRowSpan(int rowSpan) {
        if (this.cellPart == null) {
            this.cellPart = new CellPart();
        }
        this.cellPart.rowSpan = rowSpan;
    }

    @Override
    public int getColumnSpan() {
        return this.cellPart != null ? this.cellPart.columnSpan : 1;
    }

    @Override
    public void setColumnSpan(int columnSpan) {
        if (this.cellPart == null) {
            this.cellPart = new CellPart();
        }
        this.cellPart.columnSpan = columnSpan;
    }

    @Override
    public ExcelStyle getStyle() {
        return this.cellPart != null ? this.cellPart.style : null;
    }

    @Override
    public ExcelHyperLink getHyperLink() {
        return this.cellPart != null ? this.cellPart.hyperLink : null;
    }

    @Override
    public ExcelComment getComment() {
        return this.cellPart != null ? this.cellPart.comment : null;
    }

    public ExcelCell setStyle(ExcelStyle style) {
        if (this.cellPart == null) {
            this.cellPart = new CellPart();
        }
        this.cellPart.style = style;
        return this;
    }

    public ExcelCell setHyperLink(ExcelHyperLink hyperLink) {
        if (this.cellPart == null) {
            this.cellPart = new CellPart();
        }
        this.cellPart.hyperLink = hyperLink;
        return this;
    }

    public ExcelCell setComment(ExcelComment comment) {
        if (this.cellPart == null) {
            this.cellPart = new CellPart();
        }
        this.cellPart.comment = comment;
        return this;
    }

    @Override
    public IExcelContent getContent() {
        return this.content;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    public CellPart getCellPart() {
        return this.cellPart;
    }

    public void setContent(IExcelContent content) {
        this.content = content;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public void setCellPart(CellPart cellPart) {
        this.cellPart = cellPart;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelCell)) {
            return false;
        }
        ExcelCell other = (ExcelCell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IExcelContent this$content = this.getContent();
        IExcelContent other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        if (this.getRowIndex() != other.getRowIndex()) {
            return false;
        }
        if (this.getColumnIndex() != other.getColumnIndex()) {
            return false;
        }
        CellPart this$cellPart = this.getCellPart();
        CellPart other$cellPart = other.getCellPart();
        return !(this$cellPart == null ? other$cellPart != null : !((Object)this$cellPart).equals(other$cellPart));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelCell;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IExcelContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        result = result * 59 + this.getRowIndex();
        result = result * 59 + this.getColumnIndex();
        CellPart $cellPart = this.getCellPart();
        result = result * 59 + ($cellPart == null ? 43 : ((Object)$cellPart).hashCode());
        return result;
    }

    public String toString() {
        return "ExcelCell(content=" + this.getContent() + ", rowIndex=" + this.getRowIndex() + ", columnIndex=" + this.getColumnIndex() + ", cellPart=" + this.getCellPart() + ")";
    }

    public ExcelCell() {
    }

    public static class CellPart {
        public int rowSpan = 1;
        public int columnSpan = 1;
        protected ExcelStyle style;
        protected ExcelHyperLink hyperLink;
        protected ExcelComment comment;

        public CellPart(int rowSpan, int columnSpan) {
            this.rowSpan = rowSpan;
            this.columnSpan = columnSpan;
        }

        public static CellPart from(int rowSpan, int columnSpan) {
            return new CellPart(rowSpan, columnSpan);
        }

        public int getRowSpan() {
            return this.rowSpan;
        }

        public int getColumnSpan() {
            return this.columnSpan;
        }

        public ExcelStyle getStyle() {
            return this.style;
        }

        public ExcelHyperLink getHyperLink() {
            return this.hyperLink;
        }

        public ExcelComment getComment() {
            return this.comment;
        }

        public void setRowSpan(int rowSpan) {
            this.rowSpan = rowSpan;
        }

        public void setColumnSpan(int columnSpan) {
            this.columnSpan = columnSpan;
        }

        public void setStyle(ExcelStyle style) {
            this.style = style;
        }

        public void setHyperLink(ExcelHyperLink hyperLink) {
            this.hyperLink = hyperLink;
        }

        public void setComment(ExcelComment comment) {
            this.comment = comment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CellPart)) {
                return false;
            }
            CellPart other = (CellPart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRowSpan() != other.getRowSpan()) {
                return false;
            }
            if (this.getColumnSpan() != other.getColumnSpan()) {
                return false;
            }
            ExcelStyle this$style = this.getStyle();
            ExcelStyle other$style = other.getStyle();
            if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
                return false;
            }
            ExcelHyperLink this$hyperLink = this.getHyperLink();
            ExcelHyperLink other$hyperLink = other.getHyperLink();
            if (this$hyperLink == null ? other$hyperLink != null : !((Object)this$hyperLink).equals(other$hyperLink)) {
                return false;
            }
            ExcelComment this$comment = this.getComment();
            ExcelComment other$comment = other.getComment();
            return !(this$comment == null ? other$comment != null : !((Object)this$comment).equals(other$comment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CellPart;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRowSpan();
            result = result * 59 + this.getColumnSpan();
            ExcelStyle $style = this.getStyle();
            result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
            ExcelHyperLink $hyperLink = this.getHyperLink();
            result = result * 59 + ($hyperLink == null ? 43 : ((Object)$hyperLink).hashCode());
            ExcelComment $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : ((Object)$comment).hashCode());
            return result;
        }

        public String toString() {
            return "ExcelCell.CellPart(rowSpan=" + this.getRowSpan() + ", columnSpan=" + this.getColumnSpan() + ", style=" + this.getStyle() + ", hyperLink=" + this.getHyperLink() + ", comment=" + this.getComment() + ")";
        }

        public CellPart() {
        }
    }
}

