/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.core.ExcelCell;
import org.dreamcat.jwrap.excel.core.ExcelWorkbook;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelSheet;
import org.dreamcat.jwrap.excel.core.IExcelWriteCallback;
import org.dreamcat.jwrap.excel.style.ExcelComment;
import org.dreamcat.jwrap.excel.style.ExcelHyperLink;
import org.dreamcat.jwrap.excel.style.ExcelStyle;

public class ExcelSheet
implements IExcelSheet {
    private final String name;
    private final List<IExcelCell> cells;
    private IExcelWriteCallback writeCallback;

    public ExcelSheet(String name) {
        this.name = name;
        this.cells = new ArrayList<IExcelCell>();
    }

    public static ExcelSheet from(Sheet sheet, ExcelWorkbook<?> excelWorkbook) {
        ExcelSheet excelSheet = new ExcelSheet(sheet.getSheetName());
        int rowNum = sheet.getPhysicalNumberOfRows();
        TreeMap<Integer, Map<Integer, ExcelCell>> cellMap = new TreeMap<Integer, Map<Integer, ExcelCell>>();
        for (int i = 0; i < rowNum; ++i) {
            int start;
            Row row = sheet.getRow(i);
            if (row == null || (start = row.getFirstCellNum()) == -1) continue;
            short end = row.getLastCellNum();
            for (int j = start; j < end; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) continue;
                excelSheet.fillCellMap(cellMap, cell, i, j, excelWorkbook);
            }
        }
        excelSheet.computeSpans(cellMap, sheet);
        return excelSheet;
    }

    private void fillCellMap(Map<Integer, Map<Integer, ExcelCell>> cellMap, Cell cell, int i, int j, ExcelWorkbook<?> excelWorkbook) {
        IExcelContent content = IExcelContent.from(cell);
        ExcelCell excelCell = new ExcelCell(content, i, j);
        CellStyle style = cell.getCellStyle();
        Hyperlink hyperlink = cell.getHyperlink();
        Comment comment = cell.getCellComment();
        if (style != null) {
            ExcelStyle excelStyle = excelWorkbook.reversedStyles.get(style);
            if (excelStyle == null) {
                throw new IllegalStateException("assertion failure");
            }
            excelCell.setStyle(excelStyle);
        }
        if (hyperlink != null) {
            excelCell.setHyperLink(ExcelHyperLink.from(hyperlink));
        }
        if (comment != null) {
            excelCell.setComment(ExcelComment.from(comment));
        }
        this.cells.add(excelCell);
        cellMap.computeIfAbsent(i, it -> new TreeMap()).put(j, excelCell);
    }

    private void computeSpans(Map<Integer, Map<Integer, ExcelCell>> cellMap, Sheet sheet) {
        int numMergedRegions = sheet.getNumMergedRegions();
        if (numMergedRegions == 0) {
            return;
        }
        for (IExcelCell cell : this.cells) {
            IExcelCell topCell;
            IExcelCell leftCell = ExcelSheet.getLeftCell(cell, cellMap);
            if (leftCell != null) {
                leftCell.setColumnSpan(cell.getColumnIndex() - leftCell.getColumnIndex());
            }
            if ((topCell = ExcelSheet.getTopCell(cell, cellMap)) == null) continue;
            topCell.setRowSpan(cell.getRowIndex() - topCell.getRowIndex());
        }
        if (!this.cells.isEmpty()) {
            IExcelCell lastCell = this.cells.get(this.cells.size() - 1);
            CellRangeAddress addresses = sheet.getMergedRegion(numMergedRegions - 1);
            int ri = addresses.getFirstRow();
            int ci = addresses.getFirstColumn();
            if (lastCell.getRowIndex() == ri && lastCell.getColumnIndex() == ci) {
                lastCell.setRowSpan(addresses.getLastRow() - ri);
                lastCell.setColumnSpan(addresses.getLastColumn() - ci);
            }
        }
    }

    private static IExcelCell getLeftCell(IExcelCell cell, Map<Integer, Map<Integer, ExcelCell>> map) {
        int ri = cell.getRowIndex();
        int ci = cell.getColumnIndex();
        while (--ci >= 0) {
            ExcelCell excelCell = (ExcelCell)map.getOrDefault(ri, Collections.emptyMap()).get(ci);
            if (excelCell == null) continue;
            return excelCell;
        }
        return null;
    }

    private static IExcelCell getTopCell(IExcelCell cell, Map<Integer, Map<Integer, ExcelCell>> map) {
        int ri = cell.getRowIndex();
        int ci = cell.getColumnIndex();
        while (--ri >= 0) {
            ExcelCell excelCell = (ExcelCell)map.getOrDefault(ri, Collections.emptyMap()).get(ci);
            if (excelCell == null) continue;
            return excelCell;
        }
        return null;
    }

    @Override
    public IExcelWriteCallback writeCallback() {
        return this.writeCallback;
    }

    @Override
    public Iterator<IExcelCell> iterator() {
        return this.cells.iterator();
    }

    public void addCell(IExcelCell cell) {
        this.cells.add(cell);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<IExcelCell> getCells() {
        return this.cells;
    }

    public IExcelWriteCallback getWriteCallback() {
        return this.writeCallback;
    }

    public void setWriteCallback(IExcelWriteCallback writeCallback) {
        this.writeCallback = writeCallback;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelSheet)) {
            return false;
        }
        ExcelSheet other = (ExcelSheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<IExcelCell> this$cells = this.getCells();
        List<IExcelCell> other$cells = other.getCells();
        if (this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells)) {
            return false;
        }
        IExcelWriteCallback this$writeCallback = this.getWriteCallback();
        IExcelWriteCallback other$writeCallback = other.getWriteCallback();
        return !(this$writeCallback == null ? other$writeCallback != null : !this$writeCallback.equals(other$writeCallback));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelSheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<IExcelCell> $cells = this.getCells();
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        IExcelWriteCallback $writeCallback = this.getWriteCallback();
        result = result * 59 + ($writeCallback == null ? 43 : $writeCallback.hashCode());
        return result;
    }

    public String toString() {
        return "ExcelSheet(name=" + this.getName() + ", cells=" + this.getCells() + ", writeCallback=" + this.getWriteCallback() + ")";
    }
}

