/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dreamcat.jwrap.excel.content.ExcelPicture;
import org.dreamcat.jwrap.excel.core.ExcelSheet;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelSheet;
import org.dreamcat.jwrap.excel.core.IExcelWorkbook;
import org.dreamcat.jwrap.excel.style.ExcelFont;
import org.dreamcat.jwrap.excel.style.ExcelStyle;
import org.dreamcat.jwrap.excel.util.InternalUtil;

public class ExcelWorkbook<T extends IExcelSheet>
implements IExcelWorkbook<T> {
    final List<ExcelPicture> pictures;
    final List<T> sheets = new ArrayList<T>();
    final Map<ExcelFont, Font> fonts = new HashMap<ExcelFont, Font>();
    final Map<Font, ExcelFont> reversedFonts = new HashMap<Font, ExcelFont>();
    final Map<ExcelStyle, CellStyle> styles = new HashMap<ExcelStyle, CellStyle>();
    final Map<CellStyle, ExcelStyle> reversedStyles = new HashMap<CellStyle, ExcelStyle>();

    public ExcelWorkbook() {
        this.pictures = new ArrayList<ExcelPicture>();
    }

    public static ExcelWorkbook<ExcelSheet> from(File file) throws IOException, InvalidFormatException {
        try (XSSFWorkbook workbook = new XSSFWorkbook(file);){
            ExcelWorkbook<ExcelSheet> excelWorkbook = ExcelWorkbook.from((Workbook)workbook);
            return excelWorkbook;
        }
    }

    public static ExcelWorkbook<ExcelSheet> fromBigGrid(File file) throws IOException, InvalidFormatException {
        try (SXSSFWorkbook workbook = new SXSSFWorkbook(new XSSFWorkbook(file));){
            ExcelWorkbook<ExcelSheet> excelWorkbook = ExcelWorkbook.from((Workbook)workbook);
            return excelWorkbook;
        }
    }

    public static ExcelWorkbook<ExcelSheet> from2003(File file) throws IOException {
        try (HSSFWorkbook workbook = new HSSFWorkbook(new POIFSFileSystem(file, true));){
            ExcelWorkbook<ExcelSheet> excelWorkbook = ExcelWorkbook.from((Workbook)workbook);
            return excelWorkbook;
        }
    }

    public static ExcelWorkbook<ExcelSheet> from(Workbook workbook) {
        ExcelWorkbook<ExcelSheet> excelWorkbook = new ExcelWorkbook<ExcelSheet>();
        int fontNum = workbook.getNumberOfFonts();
        for (int i = 0; i < fontNum; ++i) {
            Font font = workbook.getFontAt(i);
            ExcelFont excelFont = ExcelFont.from(font);
            excelWorkbook.fonts.put(excelFont, font);
        }
        int cellStyleNum = workbook.getNumCellStyles();
        for (int i = 0; i < cellStyleNum; ++i) {
            CellStyle cellStyle = workbook.getCellStyleAt(i);
            Font font = InternalUtil.getFont(cellStyle.getFontIndex(), workbook);
            ExcelStyle excelStyle = ExcelStyle.from(cellStyle, font);
            excelWorkbook.styles.put(excelStyle, cellStyle);
        }
        int sheetNum = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetNum; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            excelWorkbook.sheets.add(ExcelSheet.from(sheet, excelWorkbook));
        }
        List pictures = workbook.getAllPictures();
        for (PictureData picture : pictures) {
            excelWorkbook.pictures.add(ExcelPicture.from(picture));
        }
        return excelWorkbook;
    }

    @Override
    public CellStyle makeCellStyle(IExcelCell excelCell, Workbook workbook) {
        ExcelStyle excelStyle = excelCell.getStyle();
        if (excelStyle == null) {
            return null;
        }
        CellStyle style = this.styles.get(excelStyle);
        if (style != null) {
            return null;
        }
        style = workbook.createCellStyle();
        this.styles.put(excelStyle, style);
        this.reversedStyles.put(style, excelStyle);
        Font font = null;
        ExcelFont excelFont = excelStyle.getFont();
        if (excelFont != null && (font = this.fonts.get(excelFont)) == null) {
            font = workbook.createFont();
            this.fonts.put(excelFont, font);
            this.reversedFonts.put(font, excelFont);
        }
        excelStyle.fill(style, font);
        return style;
    }

    @Override
    public List<ExcelPicture> getPictures() {
        return this.pictures;
    }

    @Override
    public List<T> getSheets() {
        return this.sheets;
    }
}

