/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.core;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.dreamcat.common.core.Pair;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelWorkbook;
import org.dreamcat.jwrap.excel.core.IExcelWriteCallback;
import org.dreamcat.jwrap.excel.style.ExcelComment;
import org.dreamcat.jwrap.excel.style.ExcelHyperLink;

public interface IExcelSheet
extends Iterable<IExcelCell> {
    public String getName();

    default public IExcelWriteCallback writeCallback() {
        return null;
    }

    default public void fill(Sheet sheet, int sheetIndex, IExcelWorkbook<?> excelWorkbook) {
        Workbook workbook = sheet.getWorkbook();
        IExcelWriteCallback writeCallback = this.writeCallback();
        if (writeCallback != null) {
            writeCallback.onCreateSheet(workbook, sheet, sheetIndex);
        }
        for (IExcelCell excelCell : this) {
            ExcelComment excelComment;
            ExcelHyperLink cellLink;
            Pair rowCell = Private.makeRowCell(excelCell, sheet);
            Row row = (Row)rowCell.first();
            Cell cell = (Cell)rowCell.second();
            if (writeCallback != null) {
                writeCallback.onCreateCell(workbook, sheet, sheetIndex, row, cell);
            }
            IExcelContent cellContent = excelCell.getContent();
            cellContent.fill(cell);
            CellStyle style = excelWorkbook.makeCellStyle(excelCell, workbook);
            if (style != null) {
                cell.setCellStyle(style);
            }
            if ((cellLink = excelCell.getHyperLink()) != null) {
                cellLink.fill(cell, workbook, excelCell);
            }
            if ((excelComment = excelCell.getComment()) != null) {
                excelComment.fill(cell, sheet);
            }
            if (writeCallback == null) continue;
            writeCallback.onFinishCell(workbook, sheet, sheetIndex, row, cell, cellContent, style);
        }
        if (writeCallback != null) {
            writeCallback.onFinishSheet(workbook, sheet, sheetIndex);
        }
    }

    public static final class Private {
        private Private() {
        }

        private static Pair<Row, Cell> makeRowCell(IExcelCell excelCell, Sheet sheet) {
            Row row;
            int ri = excelCell.getRowIndex();
            int ci = excelCell.getColumnIndex();
            if (excelCell.hasMergedRegion()) {
                int rs = excelCell.getRowSpan();
                int cs = excelCell.getColumnSpan();
                sheet.addMergedRegion(new CellRangeAddress(ri, ri + rs - 1, ci, ci + cs - 1));
            }
            if ((row = sheet.getRow(ri)) == null) {
                row = sheet.createRow(ri);
            }
            Cell cell = row.createCell(ci);
            return Pair.of((Object)row, (Object)cell);
        }
    }
}

