/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dreamcat.jwrap.excel.content.ExcelPicture;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelSheet;

public interface IExcelWorkbook<T extends IExcelSheet>
extends Iterable<T> {
    @Override
    default public Iterator<T> iterator() {
        return this.getSheets().iterator();
    }

    public List<T> getSheets();

    default public IExcelWorkbook<T> addSheet(T sheet) {
        this.getSheets().add(sheet);
        return this;
    }

    default public IExcelWorkbook<T> addSheets(Iterable<T> sheets) {
        for (IExcelSheet sheet : sheets) {
            this.addSheet(sheet);
        }
        return this;
    }

    public List<ExcelPicture> getPictures();

    default public IExcelWorkbook<T> addPicture(ExcelPicture picture) {
        this.getPictures().add(picture);
        return this;
    }

    default public IExcelWorkbook<T> addPictures(Collection<ExcelPicture> pictures) {
        this.getPictures().addAll(pictures);
        return this;
    }

    public CellStyle makeCellStyle(IExcelCell var1, Workbook var2);

    default public XSSFWorkbook toWorkbook() {
        return this.toWorkbook(new XSSFWorkbook());
    }

    default public SXSSFWorkbook toWorkbookWithBigGrid() {
        return this.toWorkbook(new SXSSFWorkbook());
    }

    default public HSSFWorkbook toWorkbook2003() {
        return this.toWorkbook(new HSSFWorkbook());
    }

    default public <W extends Workbook> W toWorkbook(W workbook) {
        int sheetIndex = 0;
        for (IExcelSheet excelSheet : this) {
            Sheet sheet = workbook.createSheet(excelSheet.getName());
            excelSheet.fill(sheet, sheetIndex++, this);
        }
        List<ExcelPicture> pictures = this.getPictures();
        for (ExcelPicture picture : pictures) {
            picture.fill(workbook);
        }
        return workbook;
    }

    default public void writeTo(String newFile) throws IOException {
        this.writeTo(new File(newFile));
    }

    default public void writeTo(File newFile) throws IOException {
        try (FileOutputStream ostream = new FileOutputStream(newFile);){
            this.writeTo(ostream);
        }
    }

    default public void writeTo(OutputStream output) throws IOException {
        try (XSSFWorkbook workbook = this.toWorkbook();){
            workbook.write(output);
        }
    }

    default public void writeToWithBigGrid(String newFile) throws IOException {
        this.writeToWithBigGrid(new File(newFile));
    }

    default public void writeToWithBigGrid(File newFile) throws IOException {
        try (FileOutputStream ostream = new FileOutputStream(newFile);){
            this.writeToWithBigGrid(ostream);
        }
    }

    default public void writeToWithBigGrid(OutputStream output) throws IOException {
        try (SXSSFWorkbook workbook = this.toWorkbookWithBigGrid();){
            workbook.write(output);
        }
    }

    default public void writeTo2003(String newFile) throws IOException {
        this.writeTo2003(new File(newFile));
    }

    default public void writeTo2003(File newFile) throws IOException {
        try (FileOutputStream ostream = new FileOutputStream(newFile);){
            this.writeTo2003(ostream);
        }
    }

    default public void writeTo2003(OutputStream output) throws IOException {
        try (HSSFWorkbook workbook = this.toWorkbook2003();){
            workbook.write(output);
        }
    }

    /*
     * Exception decompiling
     */
    default public byte[] toByteArray() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    default public byte[] toByteArrayWithBigGrid() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    default public byte[] toByteArray2003() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

