/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.csv;

import java.lang.reflect.Field;
import java.util.List;
import org.dreamcat.common.util.ReflectUtil;
import org.dreamcat.jwrap.excel.annotation.CsvFormat;
import org.dreamcat.jwrap.excel.csv.CsvMeta;

public final class CsvBuilder {
    private CsvBuilder() {
    }

    public static CsvMeta parse(Class<?> clazz) {
        CsvMeta meta = new CsvMeta();
        CsvFormat csvFormat = clazz.getDeclaredAnnotation(CsvFormat.class);
        if (csvFormat != null) {
            try {
                meta.deserializer = csvFormat.typeDeserializer().newInstance();
                meta.serializer = csvFormat.typeSerializer().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        List fields = ReflectUtil.retrieveFields(clazz);
        int index = 0;
        for (Field field : fields) {
            int ind;
            csvFormat = field.getDeclaredAnnotation(CsvFormat.class);
            int i = index;
            if (csvFormat != null && (ind = csvFormat.index()) != -1) {
                i = ind;
            }
            CsvMeta.Cell cell = meta.computeCell(i);
            cell.index = i;
            cell.field = field;
            if (csvFormat == null) continue;
            if (csvFormat.ignored()) {
                meta.getCells().put(index, CsvMeta.IGNORED_CELL);
                continue;
            }
            try {
                cell.serializer = csvFormat.serializer().newInstance();
                cell.deserializer = csvFormat.deserializer().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            ++index;
        }
        return meta;
    }
}

