/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.csv;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dreamcat.common.io.csv.CsvReader;
import org.dreamcat.common.util.BeanUtil;
import org.dreamcat.jwrap.excel.csv.CsvBuilder;
import org.dreamcat.jwrap.excel.csv.CsvMeta;
import org.dreamcat.jwrap.excel.csv.ICsvWorkbook;

public class CsvWorkbook<T>
implements ICsvWorkbook {
    private final List<T> values;

    public CsvWorkbook(List<T> values) {
        this.values = values;
    }

    public CsvWorkbook() {
        this(new ArrayList());
    }

    public static CsvWorkbook<List<String>> from(String filename) throws IOException {
        return CsvWorkbook.from(filename, null);
    }

    public static <T> CsvWorkbook<T> from(String filename, Class<T> clazz) throws IOException {
        return CsvWorkbook.from(new File(filename), clazz);
    }

    public static CsvWorkbook<List<String>> from(File file) throws IOException {
        return CsvWorkbook.from(file, null);
    }

    public static <T> CsvWorkbook<T> from(File file, Class<T> clazz) throws IOException {
        try (FileReader reader = new FileReader(file);){
            CsvWorkbook csvWorkbook = CsvWorkbook.from(reader, clazz);
            return csvWorkbook;
        }
    }

    public static CsvWorkbook<List<String>> from(Reader reader) throws IOException {
        return CsvWorkbook.from(reader, null);
    }

    public static <T> CsvWorkbook from(Reader reader, Class<T> clazz) throws IOException {
        if (clazz == null) {
            ArrayList<List> values = new ArrayList<List>();
            try (CsvReader csvReader = new CsvReader(reader);){
                List record;
                while ((record = csvReader.readRecord()) != null) {
                    values.add(record);
                }
            }
            return new CsvWorkbook(values);
        }
        ArrayList<T> values = new ArrayList<T>();
        CsvWorkbook workbook = new CsvWorkbook(values);
        CsvMeta meta = CsvBuilder.parse(clazz);
        try (CsvReader csvReader = new CsvReader(reader);){
            List record;
            while ((record = csvReader.readRecord()) != null) {
                T object;
                if (record.isEmpty()) {
                    values.add(null);
                }
                try {
                    object = clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
                values.add(object);
                int size = record.size();
                for (int i = 0; i < size; ++i) {
                    String word = (String)record.get(i);
                    CsvMeta.Cell cell = meta.getCells().get(i);
                    if (cell == null || cell.ignored()) continue;
                    Field field = cell.field;
                    Class<?> fieldClass = field.getType();
                    Object fieldValue = null;
                    if (cell.deserializer != null) {
                        fieldValue = cell.deserializer.apply(word);
                    } else if (fieldClass.equals(String.class)) {
                        fieldValue = word;
                    } else if (fieldClass.equals(Integer.class)) {
                        fieldValue = Integer.valueOf(word);
                    } else if (fieldClass.equals(Long.class)) {
                        fieldValue = Long.valueOf(word);
                    } else if (fieldClass.equals(Double.class)) {
                        fieldValue = Double.valueOf(word);
                    } else if (fieldClass.equals(Date.class)) {
                        fieldValue = new Date(Long.parseLong(word));
                    }
                    try {
                        field.setAccessible(true);
                        field.set(object, fieldValue);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        return workbook;
    }

    @Override
    public Iterator<Iterable<String>> iterator() {
        return new Iter();
    }

    class Iter
    implements Iterator<Iterable<String>> {
        final Iterator<T> iterator;

        Iter() {
            this.iterator = CsvWorkbook.this.values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Iterable<String> next() {
            Object record = this.iterator.next();
            if (record instanceof List) {
                return (List)record;
            }
            return BeanUtil.toStringList(record, (Class[])new Class[0]);
        }
    }
}

