/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.function.UnaryOperator;

public interface ICsvWorkbook
extends Iterable<Iterable<String>> {
    public static String escapeCsv(String value) {
        if (value == null) {
            return "";
        }
        int size = value.length();
        StringBuilder sb = new StringBuilder(size + 4);
        sb.append("\"");
        boolean enclosed = false;
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            sb.append(c);
            if (c == '\"') {
                sb.append(c);
            }
            if (enclosed || c != ',' && c != '\n' && c != '\r') continue;
            enclosed = true;
        }
        if (enclosed) {
            sb.append("\"");
            return sb.toString();
        }
        return value;
    }

    public static String escapeTsv(String value) {
        return value;
    }

    default public void writeToCsv(String newFile) throws IOException {
        this.writeToCsv(new File(newFile));
    }

    default public void writeToCsv(File newFile) throws IOException {
        try (FileWriter writer = new FileWriter(newFile);){
            this.writeToCsv(writer);
        }
    }

    default public void writeToTsv(String newFile) throws IOException {
        this.writeToTsv(new File(newFile));
    }

    default public void writeToTsv(File newFile) throws IOException {
        try (FileWriter writer = new FileWriter(newFile);){
            this.writeToTsv(writer);
        }
    }

    default public void writeToCsv(Writer writer) throws IOException {
        this.writeTo(writer, ",", ICsvWorkbook::escapeCsv);
    }

    default public void writeToTsv(Writer writer) throws IOException {
        this.writeTo(writer, "\t", ICsvWorkbook::escapeTsv);
    }

    default public void writeTo(Writer writer, String separator, UnaryOperator<String> escaping) throws IOException {
        for (Iterable row : this) {
            StringBuilder rowString = new StringBuilder();
            Iterator iterator = row.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                rowString.append((String)escaping.apply(value));
                if (!iterator.hasNext()) continue;
                rowString.append(separator);
            }
            writer.write(rowString.toString());
            writer.write("\r\n");
        }
    }
}

