/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelSheet;
import org.dreamcat.jwrap.excel.core.IExcelWriteCallback;
import org.dreamcat.jwrap.excel.map.AnnotationRowSheet;
import org.dreamcat.jwrap.excel.map.XlsHeaderMeta;
import org.dreamcat.jwrap.excel.style.ExcelStyle;

public class AnnotationListSheet
implements IExcelSheet {
    private String name;
    private final List schemes;
    private boolean annotationStyle;
    private IExcelWriteCallback writeCallback;

    public AnnotationListSheet(String name) {
        this(name, new ArrayList(0));
    }

    public AnnotationListSheet(String name, List schemes) {
        this.name = name;
        this.schemes = schemes;
    }

    public void add(Object row) {
        this.schemes.add(row);
    }

    public void addAll(Collection scheme) {
        this.schemes.addAll(scheme);
    }

    public void addSheet(IExcelSheet sheet) {
        this.schemes.add(sheet);
    }

    public void addHeader(Class<?> clazz) {
        XlsHeaderMeta meta = XlsHeaderMeta.parse(clazz);
        this.addSheet(meta);
        this.name = meta.name;
    }

    @Override
    public Iterator<IExcelCell> iterator() {
        return new Iter();
    }

    @Override
    public IExcelWriteCallback writeCallback() {
        return this.writeCallback;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List getSchemes() {
        return this.schemes;
    }

    public boolean isAnnotationStyle() {
        return this.annotationStyle;
    }

    public IExcelWriteCallback getWriteCallback() {
        return this.writeCallback;
    }

    public void setAnnotationStyle(boolean annotationStyle) {
        this.annotationStyle = annotationStyle;
    }

    public void setWriteCallback(IExcelWriteCallback writeCallback) {
        this.writeCallback = writeCallback;
    }

    private class Iter
    implements Iterator<IExcelCell>,
    IExcelCell {
        int offset;
        int schemeSize;
        int schemeIndex;
        IExcelCell cell;
        int maxRowOffset;
        Iterator<IExcelCell> iterator;
        boolean nextInRowSheetIterCase;
        boolean inSwitchIterCase;
        AnnotationRowSheet.Iter rowSheetIter;

        private Iter() {
            this.schemeSize = AnnotationListSheet.this.schemes.size();
            if (this.schemeSize == 0) {
                return;
            }
            this.move();
        }

        @Override
        public IExcelContent getContent() {
            return this.cell.getContent();
        }

        @Override
        public int getRowIndex() {
            return this.cell.getRowIndex() + this.offset;
        }

        @Override
        public int getColumnIndex() {
            return this.cell.getColumnIndex();
        }

        @Override
        public int getRowSpan() {
            return this.cell.getRowSpan();
        }

        @Override
        public int getColumnSpan() {
            return this.cell.getColumnSpan();
        }

        @Override
        public ExcelStyle getStyle() {
            if ((this.nextInRowSheetIterCase || this.inSwitchIterCase) && !AnnotationListSheet.this.annotationStyle) {
                return null;
            }
            return this.cell.getStyle();
        }

        @Override
        public boolean hasNext() {
            if (this.schemeSize == 0) {
                return false;
            }
            if (this.maxRowOffset < 0) {
                this.offset -= this.maxRowOffset;
                this.maxRowOffset = 0;
            }
            return this.iterator != null && this.iterator.hasNext() || this.nextInRowSheetIterCase && this.rowSheetIter != null && this.rowSheetIter.hasNext();
        }

        @Override
        public IExcelCell next() {
            this.inSwitchIterCase = false;
            if (!this.nextInRowSheetIterCase && this.iterator != null) {
                this.cell = this.iterator.next();
                this.maxRowOffset = Math.max(this.maxRowOffset, this.cell.getRowSpan());
                if (this.iterator.hasNext()) {
                    return this;
                }
            }
            if (this.nextInRowSheetIterCase && this.rowSheetIter != null) {
                this.cell = this.rowSheetIter.next();
                this.maxRowOffset = Math.max(this.maxRowOffset, this.cell.getRowSpan());
                if (this.rowSheetIter.hasNext()) {
                    return this;
                }
            }
            this.iterator = null;
            ++this.schemeIndex;
            if (this.schemeIndex < this.schemeSize) {
                this.move();
            } else {
                this.nextInRowSheetIterCase = false;
                this.rowSheetIter = null;
                this.inSwitchIterCase = true;
            }
            return this;
        }

        private void move() {
            this.maxRowOffset = -this.maxRowOffset;
            this.inSwitchIterCase = this.nextInRowSheetIterCase;
            Object rawScheme = AnnotationListSheet.this.schemes.get(this.schemeIndex);
            if (rawScheme instanceof IExcelSheet) {
                this.iterator = ((IExcelSheet)rawScheme).iterator();
                this.nextInRowSheetIterCase = false;
            } else {
                if (this.rowSheetIter == null) {
                    AnnotationRowSheet rowSheet = new AnnotationRowSheet(rawScheme);
                    this.rowSheetIter = rowSheet.new AnnotationRowSheet.Iter();
                } else {
                    this.rowSheetIter.reset(rawScheme);
                }
                this.nextInRowSheetIterCase = true;
            }
            this.inSwitchIterCase = this.inSwitchIterCase && !this.nextInRowSheetIterCase;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSchemeSize() {
            return this.schemeSize;
        }

        public int getSchemeIndex() {
            return this.schemeIndex;
        }

        public IExcelCell getCell() {
            return this.cell;
        }

        public int getMaxRowOffset() {
            return this.maxRowOffset;
        }

        public Iterator<IExcelCell> getIterator() {
            return this.iterator;
        }

        public boolean isNextInRowSheetIterCase() {
            return this.nextInRowSheetIterCase;
        }

        public boolean isInSwitchIterCase() {
            return this.inSwitchIterCase;
        }

        public AnnotationRowSheet.Iter getRowSheetIter() {
            return this.rowSheetIter;
        }
    }
}

