/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.dreamcat.common.util.ObjectUtil;
import org.dreamcat.common.util.ReflectUtil;
import org.dreamcat.jwrap.excel.content.ExcelUnionContent;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelSheet;
import org.dreamcat.jwrap.excel.map.XlsMeta;
import org.dreamcat.jwrap.excel.style.ExcelStyle;

public class AnnotationRowSheet
implements IExcelSheet {
    private final Map<Class, MetaCacheLine> metaMap = new HashMap<Class, MetaCacheLine>();
    private String name;
    private Object scheme;
    private XlsMeta meta;
    private List<Integer> indexes;

    public AnnotationRowSheet(Object scheme) {
        this.reset(scheme);
    }

    private static boolean isNotListOrArray(Object o) {
        return !(o instanceof List) && !o.getClass().isArray();
    }

    public void reset(Object scheme) {
        Class<?> clazz = scheme.getClass();
        if (this.metaMap.containsKey(clazz)) {
            return;
        }
        this.meta = XlsMeta.parse(clazz);
        this.checkMetaName(clazz);
        this.indexes = this.meta.getFieldIndexes();
        this.metaMap.put(clazz, new MetaCacheLine(this.meta, this.indexes));
        this.name = this.meta.name;
        this.scheme = scheme;
    }

    @Override
    public Iterator<IExcelCell> iterator() {
        return new Iter();
    }

    private void checkMetaName(Class clazz) {
        if (ObjectUtil.isEmpty((String)this.meta.name)) {
            throw new IllegalArgumentException("sheet name is empty in " + clazz + ", check its annotations");
        }
    }

    public Map<Class, MetaCacheLine> getMetaMap() {
        return this.metaMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object getScheme() {
        return this.scheme;
    }

    public XlsMeta getMeta() {
        return this.meta;
    }

    public List<Integer> getIndexes() {
        return this.indexes;
    }

    public void setName(String name) {
        this.name = name;
    }

    class Iter
    extends ExcelUnionContent
    implements Iterator<IExcelCell>,
    IExcelCell {
        XlsMeta subMeta;
        List<Integer> subIndexes;
        List row;
        int schemeSize;
        int schemeIndex;
        int maxRowSpan;
        int offset;
        Object scalar;
        List scalarArray;
        int scalarArraySize;
        int scalarArrayIndex;
        List vector;
        int vectorSize;
        int vectorIndex;
        List<List> vectorArray;
        int vectorArraySize;
        int vectorArrayIndex;
        int vectorArrayColumnSize;
        int vectorArrayColumnIndex;
        List dynamic;
        int dynamicSize;
        int dynamicIndex;
        List<List> dynamicArray;
        int dynamicArraySize;
        int dynamicArrayIndex;
        int dynamicArrayColumnSize;
        int dynamicArrayColumnIndex;
        int rowIndex;
        int columnIndex;
        int rowSpan;
        int columnSpan;
        ExcelStyle style;

        Iter() {
            this.init();
        }

        public void reset(Object scheme) {
            AnnotationRowSheet.this.reset(scheme);
            this.subMeta = null;
            this.subIndexes = null;
            this.scalar = null;
            this.scalarArray = null;
            this.scalarArraySize = 0;
            this.scalarArrayIndex = 0;
            this.vector = null;
            this.vectorSize = 0;
            this.vectorIndex = 0;
            this.vectorArray = null;
            this.vectorArraySize = 0;
            this.vectorArrayIndex = 0;
            this.vectorArrayColumnSize = 0;
            this.vectorArrayColumnIndex = 0;
            this.dynamic = null;
            this.dynamicSize = 0;
            this.dynamicIndex = 0;
            this.dynamicArray = null;
            this.dynamicArraySize = 0;
            this.dynamicArrayIndex = 0;
            this.dynamicArrayColumnSize = 0;
            this.dynamicArrayColumnIndex = 0;
            this.init();
        }

        private void init() {
            this.row = AnnotationRowSheet.this.meta.getFieldValues(AnnotationRowSheet.this.scheme);
            this.maxRowSpan = 1;
            this.offset = 0;
            for (Object fieldValue : this.row) {
                if (fieldValue instanceof List) {
                    this.maxRowSpan = Math.max(this.maxRowSpan, ((List)fieldValue).size());
                    continue;
                }
                if (!(fieldValue instanceof Object[])) continue;
                this.maxRowSpan = Math.max(this.maxRowSpan, ((Object[])fieldValue).length);
            }
            this.schemeSize = this.row.size();
            this.schemeIndex = 0;
            if (this.schemeSize > 0) {
                this.move();
            }
        }

        @Override
        public IExcelContent getContent() {
            return this;
        }

        @Override
        public ExcelStyle getStyle() {
            return this.style != null ? this.style : null;
        }

        @Override
        public boolean hasNext() {
            if (this.schemeSize == 0) {
                return false;
            }
            if (this.schemeIndex >= this.schemeSize) {
                return false;
            }
            return this.scalar != null || this.scalarArray != null || this.vector != null || this.vectorArray != null || this.dynamic != null || this.dynamicArray != null;
        }

        @Override
        public IExcelCell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            XlsMeta.Cell cell = ((AnnotationRowSheet)AnnotationRowSheet.this).meta.cells.get(AnnotationRowSheet.this.indexes.get(this.schemeIndex));
            if (this.scalar != null) {
                this.fillContent(this.scalar, cell);
                this.rowIndex = 0;
                this.columnIndex = this.offset;
                this.rowSpan = this.maxRowSpan;
                this.columnSpan = cell.span;
                this.fillStyle(cell);
                this.scalar = null;
                this.offset += this.columnSpan;
                ++this.schemeIndex;
                if (this.schemeIndex < this.schemeSize) {
                    this.move();
                }
                return this;
            }
            if (this.scalarArray != null) {
                Object value = this.scalarArray.get(this.scalarArrayIndex);
                this.fillContent(value, cell);
                this.rowIndex = this.scalarArrayIndex++;
                this.columnIndex = this.offset;
                this.rowSpan = 1;
                this.columnSpan = cell.span;
                this.fillStyle(cell);
                if (this.scalarArrayIndex >= this.scalarArraySize) {
                    this.offset += this.columnSpan;
                    this.scalarArray = null;
                    ++this.schemeIndex;
                    if (this.schemeIndex < this.schemeSize) {
                        this.move();
                    }
                }
                return this;
            }
            if (this.vector != null) {
                XlsMeta.Cell subCell = this.subMeta.cells.get(this.subIndexes.get(this.vectorIndex));
                Object value = this.vector.get(this.vectorIndex);
                this.fillContent(value, subCell);
                this.rowIndex = 0;
                this.columnIndex = this.offset++;
                this.rowSpan = this.maxRowSpan;
                this.columnSpan = subCell.span;
                this.fillStyle(subCell, cell);
                ++this.vectorIndex;
                if (this.vectorIndex >= this.vectorSize) {
                    this.vector = null;
                    ++this.schemeIndex;
                    if (this.schemeIndex < this.schemeSize) {
                        this.move();
                    }
                }
                return this;
            }
            if (this.dynamic != null) {
                Object value = this.dynamic.get(this.dynamicIndex);
                this.fillContent(value, cell);
                this.rowIndex = 0;
                this.columnIndex = this.offset++;
                this.rowSpan = this.maxRowSpan;
                this.columnSpan = cell.span;
                this.fillStyle(cell, cell);
                ++this.dynamicIndex;
                if (this.dynamicIndex >= this.dynamicSize) {
                    this.dynamic = null;
                    ++this.schemeIndex;
                    if (this.schemeIndex < this.schemeSize) {
                        this.move();
                    }
                }
                return this;
            }
            if (this.dynamicArray != null) {
                Object value = this.dynamicArray.get(this.dynamicArrayIndex).get(this.dynamicArrayColumnIndex);
                this.fillContent(value, cell);
                this.rowIndex = this.dynamicArrayIndex++;
                this.columnIndex = this.offset + this.dynamicArrayColumnIndex;
                this.rowSpan = 1;
                this.columnSpan = cell.span;
                this.fillStyle(cell, cell);
                ++this.dynamicArrayColumnIndex;
                if (this.dynamicArrayColumnIndex >= this.dynamicArrayColumnSize) {
                    this.dynamicArrayColumnIndex = 0;
                    if (this.dynamicArrayIndex >= this.dynamicArraySize) {
                        this.dynamicArray = null;
                        this.offset = this.columnIndex + this.columnSpan;
                        ++this.schemeIndex;
                        if (this.schemeIndex < this.schemeSize) {
                            this.move();
                        }
                    } else {
                        this.dynamicArrayColumnSize = this.dynamicArray.get(this.dynamicArrayIndex).size();
                    }
                }
                return this;
            }
            XlsMeta.Cell subCell = this.subMeta.cells.get(AnnotationRowSheet.this.indexes.get(this.vectorArrayColumnIndex));
            Object value = this.vectorArray.get(this.vectorArrayIndex).get(this.vectorArrayColumnIndex);
            this.fillContent(value, subCell);
            this.rowIndex = this.vectorArrayIndex++;
            this.columnIndex = this.offset + this.vectorArrayColumnIndex;
            this.rowSpan = 1;
            this.columnSpan = subCell.span;
            this.fillStyle(subCell, cell);
            ++this.vectorArrayColumnIndex;
            if (this.vectorArrayColumnIndex >= this.vectorArrayColumnSize) {
                this.vectorArrayColumnIndex = 0;
                if (this.vectorArrayIndex >= this.vectorArraySize) {
                    this.vectorArray = null;
                    this.offset = this.columnIndex + this.columnSpan;
                    ++this.schemeIndex;
                    if (this.schemeIndex < this.schemeSize) {
                        this.move();
                    }
                } else {
                    this.vectorArrayColumnSize = this.vectorArray.get(this.vectorArrayIndex).size();
                }
            }
            return this;
        }

        private void move() {
            Object fieldValue = this.row.get(this.schemeIndex);
            XlsMeta.Cell cell = ((AnnotationRowSheet)AnnotationRowSheet.this).meta.cells.get(AnnotationRowSheet.this.indexes.get(this.schemeIndex));
            if (!cell.expanded) {
                if (AnnotationRowSheet.isNotListOrArray(fieldValue)) {
                    if (fieldValue instanceof Map) {
                        Map map = (Map)fieldValue;
                        int mapSize = map.size();
                        if (mapSize == 0) {
                            throw new IllegalArgumentException("empty map field value in " + AnnotationRowSheet.this.scheme.getClass());
                        }
                        this.dynamic = new ArrayList(map.values());
                        this.dynamicSize = mapSize;
                        this.dynamicIndex = 0;
                        return;
                    }
                    this.scalar = fieldValue;
                    return;
                }
                List array = ReflectUtil.castToList(fieldValue);
                int arraySize = array.size();
                if (arraySize == 0) {
                    throw new IllegalArgumentException("empty list/array field value in " + AnnotationRowSheet.this.scheme.getClass());
                }
                if (array.get(0) instanceof Map) {
                    List mapList = array;
                    this.dynamicArraySize = arraySize;
                    this.dynamicArrayIndex = 0;
                    Map dynamicArrayFirstMap = (Map)mapList.get(0);
                    int mapSize = dynamicArrayFirstMap.size();
                    if (mapSize == 0) {
                        throw new IllegalArgumentException("empty map in list/array field value on " + AnnotationRowSheet.this.scheme.getClass());
                    }
                    this.dynamicArray = new ArrayList<List>(mapSize);
                    for (Map map : mapList) {
                        this.dynamicArray.add(new ArrayList(map.values()));
                    }
                    this.dynamicArrayColumnSize = mapSize;
                    this.dynamicArrayColumnIndex = 0;
                    return;
                }
                this.scalarArray = array;
                this.scalarArraySize = arraySize;
                this.scalarArrayIndex = 0;
                return;
            }
            if (AnnotationRowSheet.isNotListOrArray(fieldValue)) {
                MetaCacheLine cacheLine = AnnotationRowSheet.this.metaMap.computeIfAbsent(fieldValue.getClass(), c -> {
                    XlsMeta newMeta = XlsMeta.parse(c, false);
                    if (newMeta == null) {
                        throw new IllegalArgumentException("no @XlsSheet annotation on " + c);
                    }
                    return new MetaCacheLine(newMeta, newMeta.getFieldIndexes());
                });
                this.subMeta = cacheLine.meta;
                this.subIndexes = cacheLine.indexes;
                this.vector = this.subMeta.getFieldValues(fieldValue);
                this.vectorSize = this.vector.size();
                this.vectorIndex = 0;
                return;
            }
            List rectangle = ReflectUtil.castToList(fieldValue);
            if (rectangle.isEmpty()) {
                throw new IllegalArgumentException("empty list/array field value in " + AnnotationRowSheet.this.scheme.getClass());
            }
            MetaCacheLine cacheLine = AnnotationRowSheet.this.metaMap.computeIfAbsent(rectangle.get(0).getClass(), c -> {
                XlsMeta newMeta = XlsMeta.parse(c, false);
                if (newMeta == null) {
                    throw new IllegalArgumentException("no @XlsSheet annotation on " + c);
                }
                return new MetaCacheLine(newMeta, newMeta.getFieldIndexes());
            });
            this.subMeta = cacheLine.meta;
            this.subIndexes = cacheLine.indexes;
            this.vectorArray = rectangle.stream().map(this.subMeta::getFieldValues).collect(Collectors.toList());
            this.vectorArraySize = this.vectorArray.size();
            if (this.vectorArraySize == 0) {
                throw new IllegalArgumentException("empty size element on " + AnnotationRowSheet.this.scheme.getClass());
            }
            this.vectorArrayIndex = 0;
            this.vectorArrayColumnSize = this.vectorArray.get(0).size();
            this.vectorArrayColumnIndex = 0;
        }

        private void fillStyle(XlsMeta.Cell cell) {
            this.style = cell.style != null ? cell.style : ((AnnotationRowSheet)AnnotationRowSheet.this).meta.defaultStyle;
        }

        private void fillStyle(XlsMeta.Cell subCell, XlsMeta.Cell cell) {
            this.style = subCell.style != null ? subCell.style : (this.subMeta != null && this.subMeta.defaultStyle != null ? this.subMeta.defaultStyle : (cell.style != null ? cell.style : ((AnnotationRowSheet)AnnotationRowSheet.this).meta.defaultStyle));
        }

        private void fillContent(Object value, XlsMeta.Cell cell) {
            if (cell.serializer == null) {
                this.setContent(value);
            } else {
                this.setContent(cell.serializer.apply(value));
            }
        }

        public XlsMeta getSubMeta() {
            return this.subMeta;
        }

        public List<Integer> getSubIndexes() {
            return this.subIndexes;
        }

        public List getRow() {
            return this.row;
        }

        public int getSchemeSize() {
            return this.schemeSize;
        }

        public int getSchemeIndex() {
            return this.schemeIndex;
        }

        public int getMaxRowSpan() {
            return this.maxRowSpan;
        }

        public int getOffset() {
            return this.offset;
        }

        public Object getScalar() {
            return this.scalar;
        }

        public List getScalarArray() {
            return this.scalarArray;
        }

        public int getScalarArraySize() {
            return this.scalarArraySize;
        }

        public int getScalarArrayIndex() {
            return this.scalarArrayIndex;
        }

        public List getVector() {
            return this.vector;
        }

        public int getVectorSize() {
            return this.vectorSize;
        }

        public int getVectorIndex() {
            return this.vectorIndex;
        }

        public List<List> getVectorArray() {
            return this.vectorArray;
        }

        public int getVectorArraySize() {
            return this.vectorArraySize;
        }

        public int getVectorArrayIndex() {
            return this.vectorArrayIndex;
        }

        public int getVectorArrayColumnSize() {
            return this.vectorArrayColumnSize;
        }

        public int getVectorArrayColumnIndex() {
            return this.vectorArrayColumnIndex;
        }

        public List getDynamic() {
            return this.dynamic;
        }

        public int getDynamicSize() {
            return this.dynamicSize;
        }

        public int getDynamicIndex() {
            return this.dynamicIndex;
        }

        public List<List> getDynamicArray() {
            return this.dynamicArray;
        }

        public int getDynamicArraySize() {
            return this.dynamicArraySize;
        }

        public int getDynamicArrayIndex() {
            return this.dynamicArrayIndex;
        }

        public int getDynamicArrayColumnSize() {
            return this.dynamicArrayColumnSize;
        }

        public int getDynamicArrayColumnIndex() {
            return this.dynamicArrayColumnIndex;
        }

        @Override
        public int getRowIndex() {
            return this.rowIndex;
        }

        @Override
        public int getColumnIndex() {
            return this.columnIndex;
        }

        @Override
        public int getRowSpan() {
            return this.rowSpan;
        }

        @Override
        public int getColumnSpan() {
            return this.columnSpan;
        }
    }

    static class MetaCacheLine {
        XlsMeta meta;
        List<Integer> indexes;

        public MetaCacheLine(XlsMeta meta, List<Integer> indexes) {
            this.meta = meta;
            this.indexes = indexes;
        }
    }
}

