/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.dreamcat.common.x.bean.BeanMapUtil;
import org.dreamcat.jwrap.excel.content.ExcelUnionContent;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelSheet;
import org.dreamcat.jwrap.excel.map.XlsHeaderMeta;

public class SimpleListSheet
implements IExcelSheet {
    private String name;
    private final List schemes;

    public SimpleListSheet(String name) {
        this(name, new ArrayList(0));
    }

    public SimpleListSheet(String name, List schemes) {
        this.name = name;
        this.schemes = schemes;
    }

    public void add(Object row) {
        this.schemes.add(row);
    }

    public void addAll(Collection scheme) {
        this.schemes.addAll(scheme);
    }

    public void addCell(IExcelCell cell) {
        this.schemes.add(cell);
    }

    public void addHeader(Class<?> clazz) {
        XlsHeaderMeta meta = XlsHeaderMeta.parse(clazz);
        this.addAll(meta.getHeaderCells());
        this.name = meta.name;
    }

    @Override
    public Iterator<IExcelCell> iterator() {
        return new Iter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List getSchemes() {
        return this.schemes;
    }

    private class Iter
    extends ExcelUnionContent
    implements Iterator<IExcelCell>,
    IExcelCell {
        int offset = 0;
        int schemeSize;
        int schemeIndex;
        List row;
        int columnSize;
        int columnIndex;
        IExcelCell cell;
        IExcelCell nextCell;
        int maxRowOffset;

        private Iter() {
            if (SimpleListSheet.this.schemes.isEmpty()) {
                this.clear(true);
                return;
            }
            this.schemeSize = SimpleListSheet.this.schemes.size();
            this.schemeIndex = 0;
            this.columnIndex = -1;
            this.setRow(SimpleListSheet.this.schemes.get(0));
            if (this.nextCell != null) {
                return;
            }
            if (this.row.isEmpty()) {
                this.clear(true);
                return;
            }
            this.columnSize = this.row.size();
        }

        @Override
        public IExcelContent getContent() {
            return this;
        }

        @Override
        public int getRowIndex() {
            if (this.cell != null) {
                return this.cell.getRowIndex() + this.offset;
            }
            return this.offset;
        }

        @Override
        public int getColumnIndex() {
            if (this.cell != null) {
                return this.cell.getColumnIndex();
            }
            return this.columnIndex;
        }

        @Override
        public int getRowSpan() {
            if (this.cell != null) {
                return this.cell.getRowSpan();
            }
            return 1;
        }

        @Override
        public int getColumnSpan() {
            if (this.cell != null) {
                return this.cell.getColumnSpan();
            }
            return 1;
        }

        @Override
        public boolean hasNext() {
            if (this.columnSize == -1) {
                return false;
            }
            if (this.schemeIndex >= this.schemeSize) {
                return false;
            }
            if (this.nextCell != null) {
                return true;
            }
            return this.columnIndex < this.columnSize - 1 || this.schemeIndex < this.schemeSize - 1;
        }

        @Override
        public IExcelCell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextCell != null) {
                this.setCellAndMove();
                return this;
            }
            if (this.cell != null) {
                this.cell = null;
                this.offset += this.maxRowOffset;
                this.maxRowOffset = 0;
            }
            ++this.columnIndex;
            if (this.columnIndex >= this.columnSize) {
                ++this.schemeIndex;
                this.setRow(SimpleListSheet.this.schemes.get(this.schemeIndex));
                ++this.offset;
                this.columnIndex = -1;
                if (this.row == null) {
                    this.setCellAndMove();
                    return this;
                }
            }
            if (this.columnIndex == -1) {
                this.columnIndex = 0;
            }
            Object value = this.row.get(this.columnIndex);
            this.setContent(value);
            return this;
        }

        private void setCellAndMove() {
            this.cell = this.nextCell;
            this.maxRowOffset = Math.max(this.cell.getRowIndex() + this.cell.getRowSpan(), this.maxRowOffset);
            ++this.schemeIndex;
            if (this.schemeIndex < this.schemeSize) {
                this.setRow(SimpleListSheet.this.schemes.get(this.schemeIndex));
            } else {
                this.nextCell = null;
            }
            this.setRawContent(this.cell.getContent());
        }

        private void clear(boolean initial) {
            this.schemeSize = 0;
            this.columnSize = -1;
            if (initial) {
                return;
            }
            this.row = null;
            this.cell = null;
            this.nextCell = null;
        }

        private void setRow(Object rawRow) {
            if (rawRow instanceof IExcelCell) {
                this.nextCell = (IExcelCell)rawRow;
                this.row = null;
                return;
            }
            this.row = rawRow instanceof List ? (List)rawRow : (rawRow instanceof Map ? new ArrayList(((Map)rawRow).values()) : BeanMapUtil.toList((Object)rawRow));
            this.columnSize = this.row.size();
            this.nextCell = null;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSchemeSize() {
            return this.schemeSize;
        }

        public int getSchemeIndex() {
            return this.schemeIndex;
        }

        public List getRow() {
            return this.row;
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public IExcelCell getCell() {
            return this.cell;
        }

        public IExcelCell getNextCell() {
            return this.nextCell;
        }

        public int getMaxRowOffset() {
            return this.maxRowOffset;
        }
    }
}

