/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.map;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dreamcat.common.util.ReflectUtil;
import org.dreamcat.common.util.StringUtil;
import org.dreamcat.jwrap.excel.annotation.XlsHeader;
import org.dreamcat.jwrap.excel.core.ExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.core.IExcelSheet;
import org.dreamcat.jwrap.excel.style.ExcelFont;
import org.dreamcat.jwrap.excel.style.ExcelStyle;
import org.dreamcat.jwrap.excel.util.ExcelBuilder;
import org.dreamcat.jwrap.excel.util.InternalUtil;

public class XlsHeaderMeta
implements IExcelSheet {
    public String name;
    public ExcelStyle defaultStyle;
    public final Map<Integer, Cell> headers = new HashMap<Integer, Cell>();
    boolean subheader;
    List<IExcelCell> headerCells;
    List<Integer> fieldIndexes;

    public synchronized List<Integer> getFieldIndexes() {
        if (this.fieldIndexes == null) {
            this.fieldIndexes = this.headers.keySet().stream().sorted().collect(Collectors.toList());
        }
        return this.fieldIndexes;
    }

    public synchronized List<IExcelCell> getHeaderCells() {
        if (this.headerCells == null) {
            this.initHeaderCells();
        }
        return this.headerCells;
    }

    private void initHeaderCells() {
        this.headerCells = new ArrayList<IExcelCell>();
        int offset = 0;
        int rowSpan = this.subheader ? 2 : 1;
        for (int fieldIndex : this.getFieldIndexes()) {
            Cell cell = this.headers.get(fieldIndex);
            String header = cell.getHeader();
            ExcelCell excelCell = ExcelBuilder.term(header, 0, offset);
            this.headerCells.add(excelCell);
            ExcelStyle style = cell.style;
            if (style != null) {
                excelCell.setStyle(style);
            }
            int span = cell.span;
            XlsHeaderMeta expandedMeta = cell.expandedMeta;
            if (!cell.subheader || expandedMeta == null) {
                excelCell.setRowSpan(rowSpan);
                excelCell.setColumnSpan(span);
                ++offset;
                continue;
            }
            excelCell.setRowSpan(1);
            List<IExcelCell> subCells = expandedMeta.getHeaderCells();
            for (IExcelCell c : subCells) {
                ExcelCell subCell = (ExcelCell)c;
                subCell.setColumnIndex(offset + subCell.getColumnIndex());
                ExcelStyle subCellStyle = subCell.getStyle();
                if (subCellStyle != null) continue;
                if (cell.subheaderInherited) {
                    subCell.setStyle(style);
                    continue;
                }
                subCell.setStyle(cell.subheaderStyle);
            }
            int width = subCells.size();
            excelCell.setColumnSpan(width * span);
        }
    }

    @Override
    public Iterator<IExcelCell> iterator() {
        return this.getHeaderCells().iterator();
    }

    public static XlsHeaderMeta parse(Class<?> clazz) {
        return XlsHeaderMeta.parse(clazz, true);
    }

    public static XlsHeaderMeta parse(Class<?> clazz, boolean enableExpanded) {
        XlsHeaderMeta meta = new XlsHeaderMeta();
        boolean onlyAnnotated = XlsHeaderMeta.parseXlsHeaderDefault(meta, clazz);
        List fields = ReflectUtil.retrieveFields(clazz);
        int index = 0;
        for (Field field : fields) {
            Cell cell = XlsHeaderMeta.parseXlsHeader(meta, clazz, field, index, onlyAnnotated, enableExpanded);
            if (cell == null) continue;
            ++index;
        }
        return meta;
    }

    private static boolean parseXlsHeaderDefault(XlsHeaderMeta meta, Class<?> clazz) {
        XlsHeader.Default xlsHeaderDefault = (XlsHeader.Default)ReflectUtil.retrieveAnnotation(clazz, XlsHeader.Default.class);
        if (xlsHeaderDefault == null) {
            return false;
        }
        ExcelStyle style = ExcelStyle.from(xlsHeaderDefault.style());
        style.setFont(ExcelFont.from(xlsHeaderDefault.font()));
        meta.defaultStyle = style;
        return xlsHeaderDefault.onlyAnnotated();
    }

    private static Cell parseXlsHeader(XlsHeaderMeta meta, Class<?> clazz, Field field, int index, boolean onlyAnnotated, boolean enableExpanded) {
        XlsHeader xlsHeader = field.getDeclaredAnnotation(XlsHeader.class);
        if (xlsHeader == null) {
            if (onlyAnnotated) {
                return null;
            }
            return meta.headers.computeIfAbsent(index, i -> new Cell()).fillField(index, field.getName());
        }
        if (xlsHeader.ignored()) {
            return null;
        }
        Cell cell = meta.headers.computeIfAbsent(index, i -> new Cell());
        int fieldIndex = xlsHeader.fieldIndex();
        if (fieldIndex == -1) {
            cell.fillField(index, field.getName());
        } else {
            cell.fillField(fieldIndex, field.getName());
        }
        cell.fillHeader(xlsHeader, meta);
        boolean expanded = xlsHeader.expanded();
        cell.setExpanded(expanded);
        if (!enableExpanded || !expanded) {
            return cell;
        }
        Class<?> fieldClass = InternalUtil.getFieldClass(field);
        if (Map.class.isAssignableFrom(fieldClass)) {
            throw new IllegalArgumentException("@XlsHeader(expanded=true) cannot be applied in class " + fieldClass + " on field " + field);
        }
        if (clazz.equals(fieldClass)) {
            cell.setExpandedMeta(meta);
        } else {
            XlsHeaderMeta fieldMetadata = XlsHeaderMeta.parse(fieldClass, false);
            cell.setExpandedMeta(fieldMetadata);
        }
        return cell;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Cell {
        int fieldIndex;
        String fieldName;
        int span = 1;
        boolean expanded;
        XlsHeaderMeta expandedMeta;
        String header;
        ExcelStyle style;
        boolean subheader;
        boolean subheaderInherited;
        ExcelStyle subheaderStyle;

        public String getHeader() {
            if (this.header == null) {
                this.header = this.fieldName;
            }
            return this.header;
        }

        private Cell fillField(int fieldIndex, String fieldName) {
            this.fieldIndex = fieldIndex;
            if (fieldName.length() == 1) {
                fieldName = StringUtil.toCapitalLowerCase((String)fieldName);
            }
            this.fieldName = fieldName;
            return this;
        }

        private void fillHeader(XlsHeader xlsHeader, XlsHeaderMeta meta) {
            this.header = xlsHeader.header();
            this.subheader = xlsHeader.subheader();
            if (this.subheader) {
                meta.subheader = true;
            }
            this.subheaderInherited = xlsHeader.subheaderInherited();
            this.style = ExcelStyle.from(xlsHeader.style());
            this.style.setFont(ExcelFont.from(xlsHeader.font()));
            XlsHeader.SubheaderStyle subStyle = xlsHeader.subheaderStyle();
            if (subStyle.enabled()) {
                this.subheaderStyle = ExcelStyle.from(subStyle.style());
                this.subheaderStyle.setFont(ExcelFont.from(subStyle.font()));
            }
        }

        public int getFieldIndex() {
            return this.fieldIndex;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getSpan() {
            return this.span;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public XlsHeaderMeta getExpandedMeta() {
            return this.expandedMeta;
        }

        public ExcelStyle getStyle() {
            return this.style;
        }

        public boolean isSubheader() {
            return this.subheader;
        }

        public boolean isSubheaderInherited() {
            return this.subheaderInherited;
        }

        public ExcelStyle getSubheaderStyle() {
            return this.subheaderStyle;
        }

        public void setFieldIndex(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setSpan(int span) {
            this.span = span;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }

        public void setExpandedMeta(XlsHeaderMeta expandedMeta) {
            this.expandedMeta = expandedMeta;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        public void setStyle(ExcelStyle style) {
            this.style = style;
        }

        public void setSubheader(boolean subheader) {
            this.subheader = subheader;
        }

        public void setSubheaderInherited(boolean subheaderInherited) {
            this.subheaderInherited = subheaderInherited;
        }

        public void setSubheaderStyle(ExcelStyle subheaderStyle) {
            this.subheaderStyle = subheaderStyle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cell)) {
                return false;
            }
            Cell other = (Cell)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFieldIndex() != other.getFieldIndex()) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            if (this.getSpan() != other.getSpan()) {
                return false;
            }
            if (this.isExpanded() != other.isExpanded()) {
                return false;
            }
            XlsHeaderMeta this$expandedMeta = this.getExpandedMeta();
            XlsHeaderMeta other$expandedMeta = other.getExpandedMeta();
            if (this$expandedMeta == null ? other$expandedMeta != null : !this$expandedMeta.equals(other$expandedMeta)) {
                return false;
            }
            String this$header = this.getHeader();
            String other$header = other.getHeader();
            if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
                return false;
            }
            ExcelStyle this$style = this.getStyle();
            ExcelStyle other$style = other.getStyle();
            if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
                return false;
            }
            if (this.isSubheader() != other.isSubheader()) {
                return false;
            }
            if (this.isSubheaderInherited() != other.isSubheaderInherited()) {
                return false;
            }
            ExcelStyle this$subheaderStyle = this.getSubheaderStyle();
            ExcelStyle other$subheaderStyle = other.getSubheaderStyle();
            return !(this$subheaderStyle == null ? other$subheaderStyle != null : !((Object)this$subheaderStyle).equals(other$subheaderStyle));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cell;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFieldIndex();
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            result = result * 59 + this.getSpan();
            result = result * 59 + (this.isExpanded() ? 79 : 97);
            XlsHeaderMeta $expandedMeta = this.getExpandedMeta();
            result = result * 59 + ($expandedMeta == null ? 43 : $expandedMeta.hashCode());
            String $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            ExcelStyle $style = this.getStyle();
            result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
            result = result * 59 + (this.isSubheader() ? 79 : 97);
            result = result * 59 + (this.isSubheaderInherited() ? 79 : 97);
            ExcelStyle $subheaderStyle = this.getSubheaderStyle();
            result = result * 59 + ($subheaderStyle == null ? 43 : ((Object)$subheaderStyle).hashCode());
            return result;
        }

        public String toString() {
            return "XlsHeaderMeta.Cell(fieldIndex=" + this.getFieldIndex() + ", fieldName=" + this.getFieldName() + ", span=" + this.getSpan() + ", expanded=" + this.isExpanded() + ", expandedMeta=" + this.getExpandedMeta() + ", header=" + this.getHeader() + ", style=" + this.getStyle() + ", subheader=" + this.isSubheader() + ", subheaderInherited=" + this.isSubheaderInherited() + ", subheaderStyle=" + this.getSubheaderStyle() + ")";
        }
    }
}

