/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.map;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dreamcat.common.util.ObjectUtil;
import org.dreamcat.common.util.ReflectUtil;
import org.dreamcat.common.util.StringUtil;
import org.dreamcat.common.x.bean.BeanMapUtil;
import org.dreamcat.jwrap.excel.annotation.XlsCell;
import org.dreamcat.jwrap.excel.annotation.XlsFont;
import org.dreamcat.jwrap.excel.annotation.XlsFormat;
import org.dreamcat.jwrap.excel.annotation.XlsSheet;
import org.dreamcat.jwrap.excel.annotation.XlsStyle;
import org.dreamcat.jwrap.excel.style.ExcelFont;
import org.dreamcat.jwrap.excel.style.ExcelStyle;
import org.dreamcat.jwrap.excel.util.InternalUtil;

public class XlsMeta {
    public String name;
    public ExcelStyle defaultStyle;
    public final Map<Integer, Cell> cells = new HashMap<Integer, Cell>();
    List<Integer> fieldIndexes;

    public List getFieldValues(Object row) {
        Map fields = BeanMapUtil.toMap((Object)row);
        ArrayList fieldValues = new ArrayList(fields.size());
        if (ObjectUtil.isEmpty((Map)fields)) {
            return fieldValues;
        }
        Collection<Cell> c = this.cells.values();
        for (Cell cell : c) {
            Object fieldValue = fields.get(cell.fieldName);
            if (fieldValue == null) continue;
            fieldValues.add(fieldValue);
        }
        return fieldValues;
    }

    public synchronized List<Integer> getFieldIndexes() {
        if (this.fieldIndexes == null) {
            this.fieldIndexes = this.cells.keySet().stream().sorted().collect(Collectors.toList());
        }
        return this.fieldIndexes;
    }

    private void setDefaultFont(XlsFont xlsFont) {
        if (this.defaultStyle == null) {
            this.defaultStyle = new ExcelStyle();
        }
        this.defaultStyle.setFont(ExcelFont.from(xlsFont));
    }

    public static XlsMeta parse(Class<?> clazz) {
        return XlsMeta.parse(clazz, true);
    }

    public static XlsMeta parse(Class<?> clazz, boolean enableExpanded) {
        XlsMeta meta = new XlsMeta();
        Boolean onlyAnnotated = XlsMeta.parseXlsSheet(meta, clazz);
        if (onlyAnnotated == null) {
            return null;
        }
        XlsMeta.parseXlsStyle(meta, clazz);
        XlsMeta.parseXlsFont(meta, clazz);
        List fields = ReflectUtil.retrieveFields(clazz);
        int index = 0;
        for (Field field : fields) {
            Cell cell = XlsMeta.parseXlsCell(meta, clazz, field, index, onlyAnnotated, enableExpanded);
            if (cell == null) continue;
            XlsMeta.parseXlsStyle(cell, field);
            XlsMeta.parseXlsFont(cell, field);
            XlsMeta.parseXlsFormat(cell, field);
            ++index;
        }
        return meta;
    }

    private static Boolean parseXlsSheet(XlsMeta meta, Class<?> clazz) {
        XlsSheet xlsSheet = (XlsSheet)ReflectUtil.retrieveAnnotation(clazz, XlsSheet.class);
        if (xlsSheet == null) {
            return null;
        }
        meta.name = xlsSheet.name();
        return xlsSheet.onlyAnnotated();
    }

    private static void parseXlsFont(XlsMeta meta, Class<?> clazz) {
        XlsFont xlsFont = (XlsFont)ReflectUtil.retrieveAnnotation(clazz, XlsFont.class);
        if (xlsFont == null) {
            return;
        }
        meta.setDefaultFont(xlsFont);
    }

    private static void parseXlsStyle(XlsMeta meta, Class<?> clazz) {
        XlsStyle xlsStyle = (XlsStyle)ReflectUtil.retrieveAnnotation(clazz, XlsStyle.class);
        if (xlsStyle == null) {
            return;
        }
        meta.defaultStyle = ExcelStyle.from(xlsStyle);
    }

    private static void parseXlsFont(Cell cell, Field field) {
        XlsFont xlsFont = field.getDeclaredAnnotation(XlsFont.class);
        if (xlsFont == null) {
            return;
        }
        cell.setFont(xlsFont);
    }

    private static void parseXlsStyle(Cell cell, Field field) {
        XlsStyle xlsStyle = field.getDeclaredAnnotation(XlsStyle.class);
        if (xlsStyle == null) {
            return;
        }
        ExcelStyle style = ExcelStyle.from(xlsStyle);
        cell.setStyle(style);
    }

    private static void parseXlsFormat(Cell cell, Field field) {
        XlsFormat xlsFormat = field.getDeclaredAnnotation(XlsFormat.class);
        if (xlsFormat == null) {
            return;
        }
        Class<? extends Function> serializer = xlsFormat.serializer();
        Class<? extends Function> deserializer = xlsFormat.deserializer();
        if (serializer != XlsFormat.None.class) {
            try {
                cell.serializer = (Function)ReflectUtil.newInstance(serializer);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (deserializer != XlsFormat.None.class) {
            try {
                cell.deserializer = (Function)ReflectUtil.newInstance(deserializer);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static Cell parseXlsCell(XlsMeta meta, Class<?> clazz, Field field, int index, boolean onlyAnnotated, boolean enableExpanded) {
        XlsCell xlsCell = field.getDeclaredAnnotation(XlsCell.class);
        if (xlsCell == null) {
            if (onlyAnnotated) {
                return null;
            }
            return meta.cells.computeIfAbsent(index, i -> new Cell()).fillField(index, field.getName());
        }
        if (xlsCell.ignored()) {
            return null;
        }
        Cell cell = meta.cells.computeIfAbsent(index, i -> new Cell());
        int fieldIndex = xlsCell.fieldIndex();
        if (fieldIndex == -1) {
            cell.fillField(index, field.getName());
        } else {
            cell.fillField(fieldIndex, field.getName());
        }
        cell.setSpan(xlsCell.span());
        boolean expanded = xlsCell.expanded();
        cell.setExpanded(expanded);
        if (!enableExpanded || !expanded) {
            return cell;
        }
        Class<?> fieldClass = InternalUtil.getFieldClass(field);
        if (Map.class.isAssignableFrom(fieldClass)) {
            throw new IllegalArgumentException("@XlsCell(expanded=true) cannot be applied in class " + fieldClass + " on field " + field);
        }
        if (clazz.equals(fieldClass)) {
            cell.setExpandedMeta(meta);
        } else {
            XlsMeta fieldMetadata = XlsMeta.parse(fieldClass, false);
            if (fieldMetadata == null) {
                throw new IllegalArgumentException("no @XlsSheet in class " + fieldClass + " on field " + field);
            }
            cell.setExpandedMeta(fieldMetadata);
        }
        return cell;
    }

    public static class Cell {
        int fieldIndex;
        String fieldName;
        int span = 1;
        boolean expanded;
        ExcelStyle style;
        XlsMeta expandedMeta;
        Function serializer;
        Function deserializer;

        private Cell fillField(int fieldIndex, String fieldName) {
            this.fieldIndex = fieldIndex;
            if (fieldName.length() == 1) {
                fieldName = StringUtil.toCapitalLowerCase((String)fieldName);
            }
            this.fieldName = fieldName;
            return this;
        }

        private void setFont(XlsFont xlsFont) {
            if (this.style == null) {
                this.style = new ExcelStyle();
            }
            this.style.setFont(ExcelFont.from(xlsFont));
        }

        public int getFieldIndex() {
            return this.fieldIndex;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getSpan() {
            return this.span;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public ExcelStyle getStyle() {
            return this.style;
        }

        public XlsMeta getExpandedMeta() {
            return this.expandedMeta;
        }

        public Function getSerializer() {
            return this.serializer;
        }

        public Function getDeserializer() {
            return this.deserializer;
        }

        public void setFieldIndex(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setSpan(int span) {
            this.span = span;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }

        public void setStyle(ExcelStyle style) {
            this.style = style;
        }

        public void setExpandedMeta(XlsMeta expandedMeta) {
            this.expandedMeta = expandedMeta;
        }

        public void setSerializer(Function serializer) {
            this.serializer = serializer;
        }

        public void setDeserializer(Function deserializer) {
            this.deserializer = deserializer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cell)) {
                return false;
            }
            Cell other = (Cell)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFieldIndex() != other.getFieldIndex()) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            if (this.getSpan() != other.getSpan()) {
                return false;
            }
            if (this.isExpanded() != other.isExpanded()) {
                return false;
            }
            ExcelStyle this$style = this.getStyle();
            ExcelStyle other$style = other.getStyle();
            if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
                return false;
            }
            XlsMeta this$expandedMeta = this.getExpandedMeta();
            XlsMeta other$expandedMeta = other.getExpandedMeta();
            if (this$expandedMeta == null ? other$expandedMeta != null : !this$expandedMeta.equals(other$expandedMeta)) {
                return false;
            }
            Function this$serializer = this.getSerializer();
            Function other$serializer = other.getSerializer();
            if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
                return false;
            }
            Function this$deserializer = this.getDeserializer();
            Function other$deserializer = other.getDeserializer();
            return !(this$deserializer == null ? other$deserializer != null : !this$deserializer.equals(other$deserializer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cell;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFieldIndex();
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            result = result * 59 + this.getSpan();
            result = result * 59 + (this.isExpanded() ? 79 : 97);
            ExcelStyle $style = this.getStyle();
            result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
            XlsMeta $expandedMeta = this.getExpandedMeta();
            result = result * 59 + ($expandedMeta == null ? 43 : $expandedMeta.hashCode());
            Function $serializer = this.getSerializer();
            result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
            Function $deserializer = this.getDeserializer();
            result = result * 59 + ($deserializer == null ? 43 : $deserializer.hashCode());
            return result;
        }

        public String toString() {
            return "XlsMeta.Cell(fieldIndex=" + this.getFieldIndex() + ", fieldName=" + this.getFieldName() + ", span=" + this.getSpan() + ", expanded=" + this.isExpanded() + ", style=" + this.getStyle() + ", expandedMeta=" + this.getExpandedMeta() + ", serializer=" + this.getSerializer() + ", deserializer=" + this.getDeserializer() + ")";
        }
    }
}

