/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.parse.tow;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.dreamcat.common.core.FieldColumn;
import org.dreamcat.common.util.ArrayUtil;
import org.dreamcat.common.util.ObjectUtil;
import org.dreamcat.common.util.ReflectUtil;
import org.dreamcat.jwrap.excel.parse.IExcelParser;
import org.dreamcat.jwrap.excel.parse.XlsParse;
import org.dreamcat.jwrap.excel.parse.tow.SVColumn;
import org.dreamcat.jwrap.excel.parse.tow.SVRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVParser<S, V>
implements IExcelParser<SVRow<S, V>> {
    private static final Logger log = LoggerFactory.getLogger(SVParser.class);
    private int headerIndex = 0;
    private final int scalarSequenceIndex;
    private int scalarMapSize = -1;
    private String vectorFirstHeaderName;
    private String vectorFirstHeaderRegexp;
    private final Class<S> scalarClass;
    private final Class<V> vectorClass;
    private final List<FieldColumn> scalarColumns;
    private final List<FieldColumn> vectorColumns;
    final Field scalarField;
    final Field scalarMapField;
    final Field vectorField;
    final Map<Field, Function<String, Object>> deserializerMap;

    public SVParser(Class<S> scalarClass, Class<V> vectorClass, int scalarSequenceIndex) {
        this.scalarSequenceIndex = scalarSequenceIndex;
        this.scalarClass = scalarClass;
        this.vectorClass = vectorClass;
        this.scalarColumns = FieldColumn.parse(scalarClass);
        this.vectorColumns = FieldColumn.parse(vectorClass);
        Map fieldMap = ReflectUtil.retrieveFieldMap(SVRow.class);
        this.scalarField = (Field)fieldMap.get("scalar");
        this.scalarMapField = (Field)fieldMap.get("map");
        this.vectorField = (Field)fieldMap.get("vector");
        this.deserializerMap = new HashMap<Field, Function<String, Object>>();
        SVParser.retainXlsParse(this.scalarColumns);
        SVParser.retainXlsParse(this.vectorColumns);
    }

    @Override
    public List<SVRow<S, V>> readSheetAsValue(List<List<String>> sheet) throws Exception {
        if (ObjectUtil.isEmpty(sheet)) {
            return null;
        }
        int rowSize = sheet.size();
        if (this.headerIndex >= rowSize) {
            throw new IllegalArgumentException("headerIndex >= rowSize (last row num in sheet) in this sheet");
        }
        List<String> headers = sheet.get(this.headerIndex);
        if (ObjectUtil.isEmpty(headers)) {
            throw new IllegalArgumentException("empty header row in row " + this.headerIndex);
        }
        ArrayList<SVRow<S, V>> list = new ArrayList<SVRow<S, V>>();
        block0: for (int i = this.headerIndex + 1; i < rowSize; ++i) {
            List<String> values = sheet.get(i);
            if (ObjectUtil.isEmpty(values)) {
                log.warn("empty row {}, ignore it", (Object)i);
                continue;
            }
            block1: while (true) {
                if (ObjectUtil.isEmpty(values)) {
                    if (!log.isDebugEnabled()) continue block0;
                    log.warn("empty content in row {}, ignore it", (Object)i);
                    continue block0;
                }
                int columnSize = values.size();
                if (this.scalarSequenceIndex >= columnSize) {
                    throw new IllegalArgumentException("sequenceIndex >= columnSize (last column num in row) in this sheet");
                }
                String sequence = values.get(this.scalarSequenceIndex);
                if (sequence == null) {
                    throw new IllegalArgumentException("missing sequence in row " + i);
                }
                SVRow bean = new SVRow();
                int width = this.readOneRow(bean, headers, values);
                list.add(bean);
                while (i < rowSize - 1) {
                    if (this.scalarSequenceIndex >= (columnSize = (values = sheet.get(++i)).size())) {
                        throw new IllegalArgumentException("sequenceIndex >= columnSize (last column num in row) in this sheet");
                    }
                    sequence = values.get(this.scalarSequenceIndex);
                    if (sequence != null) continue block1;
                    SVColumn<V> svColumn = this.readSVColumn(headers, values, width);
                    bean.getVector().add(svColumn);
                }
                break;
            }
        }
        return list;
    }

    private int readOneRow(SVRow<S, V> bean, List<String> headers, List<String> values) throws IllegalAccessException {
        String header;
        Object scalar = ReflectUtil.newInstance(this.scalarClass);
        this.scalarField.set(bean, scalar);
        int offset = 0;
        for (FieldColumn column : this.scalarColumns) {
            Field field = column.getField();
            List children = column.getChildren();
            List annotations = column.getAnnotations();
            if (children == null) {
                String value;
                if ((value = (String)ArrayUtil.get(values, (int)offset++)) == null) continue;
                Function deserializer = this.deserializerMap.get(field);
                if (deserializer == null) {
                    if (ObjectUtil.isEmpty((Collection)annotations)) {
                        field.set(scalar, ReflectUtil.parse((String)value, field.getType()));
                        continue;
                    }
                    XlsParse xlsParse = (XlsParse)annotations.get(0);
                    Class<? extends Function<String, Object>> deserializerClass = xlsParse.deserializer();
                    deserializer = (Function)ReflectUtil.newInstance(deserializerClass);
                    this.deserializerMap.put(field, deserializer);
                }
                field.set(scalar, deserializer.apply((String)value));
                continue;
            }
            Object fieldObject = ReflectUtil.newInstance(field.getType());
            field.set(scalar, fieldObject);
            for (FieldColumn child : children) {
                String value;
                Field childField = child.getField();
                List childAnnotations = child.getAnnotations();
                if ((value = (String)ArrayUtil.get(values, (int)offset++)) == null) continue;
                Function deserializer = this.deserializerMap.get(childField);
                if (deserializer == null) {
                    if (ObjectUtil.isEmpty((Collection)childAnnotations)) {
                        childField.set(fieldObject, ReflectUtil.parse((String)value, field.getType()));
                        continue;
                    }
                    XlsParse xlsParse = (XlsParse)childAnnotations.get(0);
                    Class<? extends Function<String, Object>> deserializerClass = xlsParse.deserializer();
                    deserializer = (Function)ReflectUtil.newInstance(deserializerClass);
                    this.deserializerMap.put(field, deserializer);
                }
                childField.set(fieldObject, deserializer.apply((String)value));
            }
        }
        if (this.scalarMapSize != -1) {
            ObjectUtil.requireNotNegative((int)this.scalarMapSize, (String)"scalarMapSize");
            offset += this.scalarMapSize;
        } else if (this.vectorFirstHeaderName != null) {
            int k;
            int size = headers.size();
            for (k = offset; k < size && !this.vectorFirstHeaderName.equals(header = (String)ArrayUtil.get(headers, (int)k)); ++k) {
            }
            if (k == size) {
                return -1;
            }
            this.fillScalarMap(bean, headers, values, offset, k);
            offset = k;
        } else if (this.vectorFirstHeaderRegexp != null) {
            int k;
            int size = headers.size();
            for (k = offset; k < size && (header = (String)ArrayUtil.get(headers, (int)k)) != null && !header.matches(this.vectorFirstHeaderRegexp); ++k) {
            }
            if (k == size) {
                return -1;
            }
            this.fillScalarMap(bean, headers, values, offset, k);
            offset = k;
        }
        int width = offset;
        ArrayList<SVColumn<V>> vector = new ArrayList<SVColumn<V>>();
        this.vectorField.set(bean, vector);
        SVColumn<V> svColumn = this.readSVColumn(headers, values, offset);
        vector.add(svColumn);
        return width;
    }

    private SVColumn<V> readSVColumn(List<String> headers, List<String> values, int offset) throws IllegalAccessException {
        SVColumn svColumn = new SVColumn();
        Object svColumnScalar = ReflectUtil.newInstance(this.vectorClass);
        this.scalarField.set(svColumn, svColumnScalar);
        for (FieldColumn column : this.vectorColumns) {
            Field field = column.getField();
            List children = column.getChildren();
            List annotations = column.getAnnotations();
            if (children == null) {
                String value;
                if ((value = (String)ArrayUtil.get(values, (int)offset++)) == null) continue;
                Function deserializer = this.deserializerMap.get(field);
                if (deserializer == null) {
                    if (ObjectUtil.isEmpty((Collection)annotations)) {
                        field.set(svColumnScalar, ReflectUtil.parse((String)value, field.getType()));
                        continue;
                    }
                    XlsParse xlsParse = (XlsParse)annotations.get(0);
                    Class<? extends Function<String, Object>> deserializerClass = xlsParse.deserializer();
                    deserializer = (Function)ReflectUtil.newInstance(deserializerClass);
                    this.deserializerMap.put(field, deserializer);
                }
                field.set(svColumnScalar, deserializer.apply((String)value));
                continue;
            }
            Object fieldObject = ReflectUtil.newInstance(field.getType());
            field.set(svColumnScalar, fieldObject);
            for (FieldColumn child : children) {
                String value;
                Field childField = child.getField();
                List childAnnotations = child.getAnnotations();
                if ((value = (String)ArrayUtil.get(values, (int)offset++)) == null) continue;
                Function deserializer = this.deserializerMap.get(childField);
                if (deserializer == null) {
                    if (ObjectUtil.isEmpty((Collection)childAnnotations)) {
                        childField.set(fieldObject, ReflectUtil.parse((String)value, field.getType()));
                        continue;
                    }
                    XlsParse xlsParse = (XlsParse)childAnnotations.get(0);
                    Class<? extends Function<String, Object>> deserializerClass = xlsParse.deserializer();
                    deserializer = (Function)ReflectUtil.newInstance(deserializerClass);
                    this.deserializerMap.put(field, deserializer);
                }
                childField.set(fieldObject, deserializer.apply((String)value));
            }
        }
        int size = headers.size();
        if (offset < size) {
            this.fillVectorMap(svColumn, headers, values, offset, size);
        }
        return svColumn;
    }

    private void fillScalarMap(SVRow<S, V> bean, List<String> headers, List<String> values, int start, int end) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.scalarMapField.set(bean, map);
        for (int i = start; i < end; ++i) {
            map.put(headers.get(i), ArrayUtil.get(values, (int)i));
        }
    }

    private void fillVectorMap(SVColumn<V> svColumn, List<String> headers, List<String> values, int start, int end) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.scalarMapField.set(svColumn, map);
        for (int i = start; i < end; ++i) {
            map.put(headers.get(i), ArrayUtil.get(values, (int)i));
        }
    }

    private static void retainXlsParse(List<FieldColumn> columns) {
        for (FieldColumn column : columns) {
            Field field = column.getField();
            field.setAccessible(true);
            List annotations = column.getAnnotations();
            if (ObjectUtil.isEmpty((Collection)annotations)) continue;
            annotations.removeIf(annotation -> !(annotation instanceof XlsParse));
            List children = column.getChildren();
            if (ObjectUtil.isEmpty((Collection)children)) continue;
            for (FieldColumn child : children) {
                Field childField = child.getField();
                childField.setAccessible(true);
                List childAnnotations = child.getAnnotations();
                if (ObjectUtil.isEmpty((Collection)childAnnotations)) continue;
                childAnnotations.removeIf(annotation -> !(annotation instanceof XlsParse));
            }
        }
    }

    public void setHeaderIndex(int headerIndex) {
        this.headerIndex = headerIndex;
    }

    public void setScalarMapSize(int scalarMapSize) {
        this.scalarMapSize = scalarMapSize;
    }

    public void setVectorFirstHeaderName(String vectorFirstHeaderName) {
        this.vectorFirstHeaderName = vectorFirstHeaderName;
    }

    public void setVectorFirstHeaderRegexp(String vectorFirstHeaderRegexp) {
        this.vectorFirstHeaderRegexp = vectorFirstHeaderRegexp;
    }
}

