/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.style;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.dreamcat.jwrap.excel.style.ExcelClientAnchor;
import org.dreamcat.jwrap.excel.style.ExcelRichString;

public class ExcelComment {
    private boolean visible;
    private String author;
    private ExcelRichString string;
    private ExcelClientAnchor clientAnchor;

    public static ExcelComment from(Comment comment) {
        ExcelComment excelComment = new ExcelComment();
        excelComment.setVisible(comment.isVisible());
        excelComment.setAuthor(comment.getAuthor());
        RichTextString string = comment.getString();
        excelComment.setString(ExcelRichString.from(string));
        ClientAnchor clientAnchor = comment.getClientAnchor();
        excelComment.setClientAnchor(ExcelClientAnchor.from(clientAnchor));
        return excelComment;
    }

    public void fill(Cell cell, Sheet sheet) {
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = this.clientAnchor.createAnchor(drawing);
        Comment comment = drawing.createCellComment(anchor);
        cell.setCellComment(comment);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getAuthor() {
        return this.author;
    }

    public ExcelRichString getString() {
        return this.string;
    }

    public ExcelClientAnchor getClientAnchor() {
        return this.clientAnchor;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setString(ExcelRichString string) {
        this.string = string;
    }

    public void setClientAnchor(ExcelClientAnchor clientAnchor) {
        this.clientAnchor = clientAnchor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelComment)) {
            return false;
        }
        ExcelComment other = (ExcelComment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        ExcelRichString this$string = this.getString();
        ExcelRichString other$string = other.getString();
        if (this$string == null ? other$string != null : !((Object)this$string).equals(other$string)) {
            return false;
        }
        ExcelClientAnchor this$clientAnchor = this.getClientAnchor();
        ExcelClientAnchor other$clientAnchor = other.getClientAnchor();
        return !(this$clientAnchor == null ? other$clientAnchor != null : !((Object)this$clientAnchor).equals(other$clientAnchor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelComment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVisible() ? 79 : 97);
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        ExcelRichString $string = this.getString();
        result = result * 59 + ($string == null ? 43 : ((Object)$string).hashCode());
        ExcelClientAnchor $clientAnchor = this.getClientAnchor();
        result = result * 59 + ($clientAnchor == null ? 43 : ((Object)$clientAnchor).hashCode());
        return result;
    }

    public String toString() {
        return "ExcelComment(visible=" + this.isVisible() + ", author=" + this.getAuthor() + ", string=" + this.getString() + ", clientAnchor=" + this.getClientAnchor() + ")";
    }

    public ExcelComment() {
    }

    public ExcelComment(boolean visible, String author, ExcelRichString string, ExcelClientAnchor clientAnchor) {
        this.visible = visible;
        this.author = author;
        this.string = string;
        this.clientAnchor = clientAnchor;
    }
}

