/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.style;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.dreamcat.jwrap.excel.annotation.XlsFont;

public class ExcelFont {
    private String name;
    private boolean bold;
    private boolean italic;
    private byte underline;
    private boolean strikeout;
    private short typeOffset;
    private short color;
    private short height;

    public static ExcelFont from(Font font) {
        ExcelFont excelFont = new ExcelFont();
        excelFont.setName(font.getFontName());
        excelFont.setBold(font.getBold());
        excelFont.setItalic(font.getItalic());
        excelFont.setUnderline(font.getUnderline());
        excelFont.setStrikeout(font.getStrikeout());
        excelFont.setTypeOffset(font.getTypeOffset());
        excelFont.setColor(font.getColor());
        excelFont.setHeight(font.getFontHeightInPoints());
        return excelFont;
    }

    public static ExcelFont from(Workbook workbook, CellStyle style) {
        XSSFFont font;
        if (style instanceof XSSFCellStyle) {
            font = ((XSSFCellStyle)style).getFont();
        } else if (style instanceof HSSFCellStyle) {
            font = ((HSSFCellStyle)style).getFont(workbook);
        } else {
            return null;
        }
        return ExcelFont.from((Font)font);
    }

    public static ExcelFont from(XlsFont xlsFont) {
        ExcelFont font = new ExcelFont();
        if (!xlsFont.name().isEmpty()) {
            font.setName(xlsFont.name());
        }
        font.setBold(xlsFont.bold());
        font.setItalic(xlsFont.italic());
        font.setStrikeout(xlsFont.strikeout());
        if (xlsFont.underline() != -1) {
            font.setUnderline(xlsFont.underline());
        }
        if (xlsFont.typeOffset() != -1) {
            font.setTypeOffset(xlsFont.typeOffset());
        }
        if (xlsFont.color() != -1) {
            font.setColor(xlsFont.color());
        } else {
            font.setColor(xlsFont.indexedColor().getIndex());
        }
        if (xlsFont.height() != -1) {
            font.setHeight(xlsFont.height());
        }
        return font;
    }

    public void fill(Font font) {
        font.setFontName(this.name);
        font.setBold(this.bold);
        font.setItalic(this.italic);
        font.setUnderline(this.underline);
        font.setStrikeout(this.strikeout);
        font.setColor(this.color);
        font.setTypeOffset(this.typeOffset);
        font.setFontHeightInPoints(this.height);
    }

    public String getName() {
        return this.name;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public byte getUnderline() {
        return this.underline;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public short getTypeOffset() {
        return this.typeOffset;
    }

    public short getColor() {
        return this.color;
    }

    public short getHeight() {
        return this.height;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public void setUnderline(byte underline) {
        this.underline = underline;
    }

    public void setStrikeout(boolean strikeout) {
        this.strikeout = strikeout;
    }

    public void setTypeOffset(short typeOffset) {
        this.typeOffset = typeOffset;
    }

    public void setColor(short color) {
        this.color = color;
    }

    public void setHeight(short height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelFont)) {
            return false;
        }
        ExcelFont other = (ExcelFont)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isBold() != other.isBold()) {
            return false;
        }
        if (this.isItalic() != other.isItalic()) {
            return false;
        }
        if (this.getUnderline() != other.getUnderline()) {
            return false;
        }
        if (this.isStrikeout() != other.isStrikeout()) {
            return false;
        }
        if (this.getTypeOffset() != other.getTypeOffset()) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        return this.getHeight() == other.getHeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelFont;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isBold() ? 79 : 97);
        result = result * 59 + (this.isItalic() ? 79 : 97);
        result = result * 59 + this.getUnderline();
        result = result * 59 + (this.isStrikeout() ? 79 : 97);
        result = result * 59 + this.getTypeOffset();
        result = result * 59 + this.getColor();
        result = result * 59 + this.getHeight();
        return result;
    }

    public String toString() {
        return "ExcelFont(name=" + this.getName() + ", bold=" + this.isBold() + ", italic=" + this.isItalic() + ", underline=" + this.getUnderline() + ", strikeout=" + this.isStrikeout() + ", typeOffset=" + this.getTypeOffset() + ", color=" + this.getColor() + ", height=" + this.getHeight() + ")";
    }
}

