/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.style;

import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Workbook;
import org.dreamcat.jwrap.excel.core.IExcelCell;

public class ExcelHyperLink {
    private HyperlinkType type;
    private String address;
    private String label;

    public static ExcelHyperLink from(Hyperlink hyperlink) {
        ExcelHyperLink link = new ExcelHyperLink();
        link.setType(hyperlink.getType());
        link.setAddress(hyperlink.getAddress());
        link.setLabel(hyperlink.getLabel());
        return link;
    }

    public void fill(Cell cell, Workbook workbook, IExcelCell excelCell) {
        CreationHelper creationHelper = workbook.getCreationHelper();
        Hyperlink link = creationHelper.createHyperlink(this.type);
        link.setAddress(this.address);
        if (this.label != null) {
            link.setLabel(this.label);
        }
        if (excelCell.hasMergedRegion()) {
            link.setFirstRow(excelCell.getRowIndex());
            link.setLastRow(excelCell.getRowIndex() + excelCell.getRowSpan() - 1);
            link.setFirstColumn(excelCell.getColumnIndex());
            link.setLastColumn(excelCell.getColumnIndex() + excelCell.getColumnSpan() - 1);
        }
        cell.setHyperlink(link);
    }

    public HyperlinkType getType() {
        return this.type;
    }

    public String getAddress() {
        return this.address;
    }

    public String getLabel() {
        return this.label;
    }

    public void setType(HyperlinkType type) {
        this.type = type;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelHyperLink)) {
            return false;
        }
        ExcelHyperLink other = (ExcelHyperLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HyperlinkType this$type = this.getType();
        HyperlinkType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelHyperLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HyperlinkType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    public String toString() {
        return "ExcelHyperLink(type=" + this.getType() + ", address=" + this.getAddress() + ", label=" + this.getLabel() + ")";
    }

    public ExcelHyperLink() {
    }

    public ExcelHyperLink(HyperlinkType type, String address, String label) {
        this.type = type;
        this.address = address;
        this.label = label;
    }
}

