/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.style;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.dreamcat.common.util.ObjectUtil;
import org.dreamcat.jwrap.excel.style.FormattingRun;

public class ExcelRichString {
    private String string;
    private List<FormattingRun> formattingRuns;

    public static ExcelRichString from(String string) {
        return new ExcelRichString(string, null);
    }

    public static ExcelRichString from(RichTextString richTextString) {
        String string = richTextString.getString();
        int numFormattingRuns = richTextString.numFormattingRuns();
        if (numFormattingRuns == 0) {
            return ExcelRichString.from(string);
        }
        ArrayList<FormattingRun> formattingRuns = new ArrayList<FormattingRun>(numFormattingRuns);
        int offset = 0;
        for (int i = 0; i < numFormattingRuns; ++i) {
            int index = richTextString.getIndexOfFormattingRun(i);
            String substring = string.substring(offset, index);
            offset = index;
            FormattingRun formattingRun = new FormattingRun(substring);
            short fontIndex = 0;
            if (richTextString instanceof HSSFRichTextString) {
                HSSFRichTextString hssfRichTextString = (HSSFRichTextString)richTextString;
                fontIndex = hssfRichTextString.getFontAtIndex(i);
            } else {
                XSSFRichTextString xssfRichTextString = (XSSFRichTextString)richTextString;
                XSSFFont xssfFont = xssfRichTextString.getFontOfFormattingRun(i);
                if (xssfFont != null) {
                    fontIndex = (short)xssfFont.getIndex();
                }
            }
            formattingRun.setFontIndex(fontIndex);
            formattingRuns.add(formattingRun);
        }
        return new ExcelRichString(string, formattingRuns);
    }

    public void fill(RichTextString richTextString) {
        if (ObjectUtil.isEmpty(this.formattingRuns)) {
            return;
        }
        int startIndex = 0;
        int endIndex = 0;
        for (FormattingRun formattingRun : this.formattingRuns) {
            String substring = formattingRun.getString();
            short fontIndex = formattingRun.getFontIndex();
            richTextString.applyFont(startIndex, endIndex += substring.length(), fontIndex);
            startIndex = endIndex;
        }
    }

    public boolean hasFormatting() {
        return ObjectUtil.isNotEmpty(this.formattingRuns);
    }

    public String getString() {
        return this.string;
    }

    public List<FormattingRun> getFormattingRuns() {
        return this.formattingRuns;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setFormattingRuns(List<FormattingRun> formattingRuns) {
        this.formattingRuns = formattingRuns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelRichString)) {
            return false;
        }
        ExcelRichString other = (ExcelRichString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$string = this.getString();
        String other$string = other.getString();
        if (this$string == null ? other$string != null : !this$string.equals(other$string)) {
            return false;
        }
        List<FormattingRun> this$formattingRuns = this.getFormattingRuns();
        List<FormattingRun> other$formattingRuns = other.getFormattingRuns();
        return !(this$formattingRuns == null ? other$formattingRuns != null : !((Object)this$formattingRuns).equals(other$formattingRuns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelRichString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $string = this.getString();
        result = result * 59 + ($string == null ? 43 : $string.hashCode());
        List<FormattingRun> $formattingRuns = this.getFormattingRuns();
        result = result * 59 + ($formattingRuns == null ? 43 : ((Object)$formattingRuns).hashCode());
        return result;
    }

    public String toString() {
        return "ExcelRichString(string=" + this.getString() + ", formattingRuns=" + this.getFormattingRuns() + ")";
    }

    public ExcelRichString() {
    }

    public ExcelRichString(String string, List<FormattingRun> formattingRuns) {
        this.string = string;
        this.formattingRuns = formattingRuns;
    }
}

