/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.style;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.dreamcat.jwrap.excel.annotation.XlsStyle;
import org.dreamcat.jwrap.excel.style.ExcelFont;

public class ExcelStyle {
    private ExcelFont font;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private boolean hidden;
    private boolean wrapText;
    private boolean locked;
    private boolean quotePrefix;
    private boolean shrinkToFit;
    private short indent = (short)-1;
    private short rotation = 0;
    private short bgColor = (short)-1;
    private short fgColor = (short)-1;
    private FillPatternType fillPattern;
    private BorderStyle borderBottom;
    private BorderStyle borderLeft;
    private BorderStyle borderTop;
    private BorderStyle borderRight;
    private short bottomBorderColor = (short)-1;
    private short leftBorderColor = (short)-1;
    private short topBorderColor = (short)-1;
    private short rightBorderColor = (short)-1;

    public static ExcelStyle from(CellStyle style, Font font) {
        ExcelStyle excelStyle = new ExcelStyle();
        if (font != null) {
            excelStyle.font = ExcelFont.from(font);
        }
        excelStyle.setHorizontalAlignment(style.getAlignment());
        excelStyle.setVerticalAlignment(style.getVerticalAlignment());
        excelStyle.setHidden(style.getHidden());
        excelStyle.setHidden(style.getWrapText());
        excelStyle.setHidden(style.getLocked());
        excelStyle.setQuotePrefix(style.getQuotePrefixed());
        excelStyle.setShrinkToFit(style.getShrinkToFit());
        excelStyle.setIndent(style.getIndention());
        excelStyle.setRotation(style.getIndention());
        excelStyle.setBgColor(style.getFillBackgroundColor());
        excelStyle.setFgColor(style.getFillForegroundColor());
        excelStyle.setFillPattern(style.getFillPattern());
        excelStyle.setBorderBottom(style.getBorderBottom());
        excelStyle.setBorderLeft(style.getBorderLeft());
        excelStyle.setBorderTop(style.getBorderTop());
        excelStyle.setBorderRight(style.getBorderRight());
        excelStyle.setBottomBorderColor(style.getBottomBorderColor());
        excelStyle.setLeftBorderColor(style.getLeftBorderColor());
        excelStyle.setTopBorderColor(style.getTopBorderColor());
        excelStyle.setRightBorderColor(style.getRightBorderColor());
        return excelStyle;
    }

    public static ExcelStyle from(XlsStyle xlsStyle) {
        ExcelStyle style = new ExcelStyle();
        style.setHorizontalAlignment(xlsStyle.horizontalAlignment());
        style.setVerticalAlignment(xlsStyle.verticalAlignment());
        style.setHidden(xlsStyle.hidden());
        style.setWrapText(xlsStyle.wrapText());
        style.setLocked(xlsStyle.locked());
        style.setQuotePrefix(xlsStyle.quotePrefix());
        style.setShrinkToFit(xlsStyle.shrinkToFit());
        style.setIndent(xlsStyle.indent());
        style.setRotation(xlsStyle.rotation());
        if (xlsStyle.bgColor() != -1) {
            style.setBgColor(xlsStyle.bgColor());
        } else {
            style.setBgColor(xlsStyle.bgIndexedColor().getIndex());
        }
        if (xlsStyle.fgColor() != -1) {
            style.setFgColor(xlsStyle.fgColor());
        } else {
            style.setFgColor(xlsStyle.fgIndexedColor().getIndex());
        }
        style.setFillPattern(xlsStyle.fillPattern());
        style.setBorderBottom(xlsStyle.borderBottom());
        style.setBorderLeft(xlsStyle.borderLeft());
        style.setBorderTop(xlsStyle.borderTop());
        style.setBorderRight(xlsStyle.borderRight());
        if (xlsStyle.bottomBorderColor() != -1) {
            style.setBottomBorderColor(xlsStyle.bottomBorderColor());
        } else {
            style.setBottomBorderColor(xlsStyle.bottomBorderIndexedColor().getIndex());
        }
        if (xlsStyle.leftBorderColor() != -1) {
            style.setLeftBorderColor(xlsStyle.leftBorderColor());
        } else {
            style.setLeftBorderColor(xlsStyle.leftBorderIndexedColor().getIndex());
        }
        if (xlsStyle.topBorderColor() != -1) {
            style.setTopBorderColor(xlsStyle.topBorderColor());
        } else {
            style.setTopBorderColor(xlsStyle.topBorderIndexedColor().getIndex());
        }
        if (xlsStyle.rightBorderColor() != -1) {
            style.setRightBorderColor(xlsStyle.rightBorderColor());
        } else {
            style.setRightBorderColor(xlsStyle.rightBorderIndexedColor().getIndex());
        }
        return style;
    }

    public void fill(CellStyle style, Font font) {
        if (font != null) {
            style.setFont(font);
        }
        if (this.horizontalAlignment != null) {
            style.setAlignment(this.horizontalAlignment);
        }
        if (this.verticalAlignment != null) {
            style.setVerticalAlignment(this.verticalAlignment);
        }
        style.setLocked(this.locked);
        style.setQuotePrefixed(this.quotePrefix);
        style.setShrinkToFit(this.shrinkToFit);
        style.setHidden(this.hidden);
        style.setWrapText(this.wrapText);
        if (this.indent != -1) {
            style.setIndention(this.indent);
        }
        if (this.rotation != 0) {
            style.setRotation(this.rotation);
        }
        if (ExcelStyle.hasColor(this.fgColor) || ExcelStyle.hasColor(this.bgColor)) {
            if (ExcelStyle.hasColor(this.fgColor)) {
                style.setFillForegroundColor(this.fgColor);
            }
            if (ExcelStyle.hasColor(this.bgColor)) {
                style.setFillBackgroundColor(this.bgColor);
            }
            if (this.fillPattern != null) {
                style.setFillPattern(this.fillPattern);
            }
        }
        if (this.borderBottom != null) {
            style.setBorderBottom(this.borderBottom);
        }
        if (this.borderLeft != null) {
            style.setBorderLeft(this.borderLeft);
        }
        if (this.borderTop != null) {
            style.setBorderTop(this.borderTop);
        }
        if (this.borderRight != null) {
            style.setBorderRight(this.borderRight);
        }
        if (ExcelStyle.hasColor(this.bottomBorderColor)) {
            style.setBottomBorderColor(this.bottomBorderColor);
        }
        if (ExcelStyle.hasColor(this.leftBorderColor)) {
            style.setLeftBorderColor(this.leftBorderColor);
        }
        if (ExcelStyle.hasColor(this.topBorderColor)) {
            style.setTopBorderColor(this.topBorderColor);
        }
        if (ExcelStyle.hasColor(this.rightBorderColor)) {
            style.setRightBorderColor(this.rightBorderColor);
        }
    }

    private static boolean hasColor(int color) {
        return color != -1 && color != IndexedColors.AUTOMATIC.getIndex();
    }

    public ExcelFont getFont() {
        return this.font;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isQuotePrefix() {
        return this.quotePrefix;
    }

    public boolean isShrinkToFit() {
        return this.shrinkToFit;
    }

    public short getIndent() {
        return this.indent;
    }

    public short getRotation() {
        return this.rotation;
    }

    public short getBgColor() {
        return this.bgColor;
    }

    public short getFgColor() {
        return this.fgColor;
    }

    public FillPatternType getFillPattern() {
        return this.fillPattern;
    }

    public BorderStyle getBorderBottom() {
        return this.borderBottom;
    }

    public BorderStyle getBorderLeft() {
        return this.borderLeft;
    }

    public BorderStyle getBorderTop() {
        return this.borderTop;
    }

    public BorderStyle getBorderRight() {
        return this.borderRight;
    }

    public short getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public short getLeftBorderColor() {
        return this.leftBorderColor;
    }

    public short getTopBorderColor() {
        return this.topBorderColor;
    }

    public short getRightBorderColor() {
        return this.rightBorderColor;
    }

    public void setFont(ExcelFont font) {
        this.font = font;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setQuotePrefix(boolean quotePrefix) {
        this.quotePrefix = quotePrefix;
    }

    public void setShrinkToFit(boolean shrinkToFit) {
        this.shrinkToFit = shrinkToFit;
    }

    public void setIndent(short indent) {
        this.indent = indent;
    }

    public void setRotation(short rotation) {
        this.rotation = rotation;
    }

    public void setBgColor(short bgColor) {
        this.bgColor = bgColor;
    }

    public void setFgColor(short fgColor) {
        this.fgColor = fgColor;
    }

    public void setFillPattern(FillPatternType fillPattern) {
        this.fillPattern = fillPattern;
    }

    public void setBorderBottom(BorderStyle borderBottom) {
        this.borderBottom = borderBottom;
    }

    public void setBorderLeft(BorderStyle borderLeft) {
        this.borderLeft = borderLeft;
    }

    public void setBorderTop(BorderStyle borderTop) {
        this.borderTop = borderTop;
    }

    public void setBorderRight(BorderStyle borderRight) {
        this.borderRight = borderRight;
    }

    public void setBottomBorderColor(short bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
    }

    public void setLeftBorderColor(short leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    public void setTopBorderColor(short topBorderColor) {
        this.topBorderColor = topBorderColor;
    }

    public void setRightBorderColor(short rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelStyle)) {
            return false;
        }
        ExcelStyle other = (ExcelStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExcelFont this$font = this.getFont();
        ExcelFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        HorizontalAlignment this$horizontalAlignment = this.getHorizontalAlignment();
        HorizontalAlignment other$horizontalAlignment = other.getHorizontalAlignment();
        if (this$horizontalAlignment == null ? other$horizontalAlignment != null : !this$horizontalAlignment.equals(other$horizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$verticalAlignment = this.getVerticalAlignment();
        VerticalAlignment other$verticalAlignment = other.getVerticalAlignment();
        if (this$verticalAlignment == null ? other$verticalAlignment != null : !this$verticalAlignment.equals(other$verticalAlignment)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isWrapText() != other.isWrapText()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        if (this.isQuotePrefix() != other.isQuotePrefix()) {
            return false;
        }
        if (this.isShrinkToFit() != other.isShrinkToFit()) {
            return false;
        }
        if (this.getIndent() != other.getIndent()) {
            return false;
        }
        if (this.getRotation() != other.getRotation()) {
            return false;
        }
        if (this.getBgColor() != other.getBgColor()) {
            return false;
        }
        if (this.getFgColor() != other.getFgColor()) {
            return false;
        }
        FillPatternType this$fillPattern = this.getFillPattern();
        FillPatternType other$fillPattern = other.getFillPattern();
        if (this$fillPattern == null ? other$fillPattern != null : !this$fillPattern.equals(other$fillPattern)) {
            return false;
        }
        BorderStyle this$borderBottom = this.getBorderBottom();
        BorderStyle other$borderBottom = other.getBorderBottom();
        if (this$borderBottom == null ? other$borderBottom != null : !this$borderBottom.equals(other$borderBottom)) {
            return false;
        }
        BorderStyle this$borderLeft = this.getBorderLeft();
        BorderStyle other$borderLeft = other.getBorderLeft();
        if (this$borderLeft == null ? other$borderLeft != null : !this$borderLeft.equals(other$borderLeft)) {
            return false;
        }
        BorderStyle this$borderTop = this.getBorderTop();
        BorderStyle other$borderTop = other.getBorderTop();
        if (this$borderTop == null ? other$borderTop != null : !this$borderTop.equals(other$borderTop)) {
            return false;
        }
        BorderStyle this$borderRight = this.getBorderRight();
        BorderStyle other$borderRight = other.getBorderRight();
        if (this$borderRight == null ? other$borderRight != null : !this$borderRight.equals(other$borderRight)) {
            return false;
        }
        if (this.getBottomBorderColor() != other.getBottomBorderColor()) {
            return false;
        }
        if (this.getLeftBorderColor() != other.getLeftBorderColor()) {
            return false;
        }
        if (this.getTopBorderColor() != other.getTopBorderColor()) {
            return false;
        }
        return this.getRightBorderColor() == other.getRightBorderColor();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExcelFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        HorizontalAlignment $horizontalAlignment = this.getHorizontalAlignment();
        result = result * 59 + ($horizontalAlignment == null ? 43 : $horizontalAlignment.hashCode());
        VerticalAlignment $verticalAlignment = this.getVerticalAlignment();
        result = result * 59 + ($verticalAlignment == null ? 43 : $verticalAlignment.hashCode());
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isWrapText() ? 79 : 97);
        result = result * 59 + (this.isLocked() ? 79 : 97);
        result = result * 59 + (this.isQuotePrefix() ? 79 : 97);
        result = result * 59 + (this.isShrinkToFit() ? 79 : 97);
        result = result * 59 + this.getIndent();
        result = result * 59 + this.getRotation();
        result = result * 59 + this.getBgColor();
        result = result * 59 + this.getFgColor();
        FillPatternType $fillPattern = this.getFillPattern();
        result = result * 59 + ($fillPattern == null ? 43 : $fillPattern.hashCode());
        BorderStyle $borderBottom = this.getBorderBottom();
        result = result * 59 + ($borderBottom == null ? 43 : $borderBottom.hashCode());
        BorderStyle $borderLeft = this.getBorderLeft();
        result = result * 59 + ($borderLeft == null ? 43 : $borderLeft.hashCode());
        BorderStyle $borderTop = this.getBorderTop();
        result = result * 59 + ($borderTop == null ? 43 : $borderTop.hashCode());
        BorderStyle $borderRight = this.getBorderRight();
        result = result * 59 + ($borderRight == null ? 43 : $borderRight.hashCode());
        result = result * 59 + this.getBottomBorderColor();
        result = result * 59 + this.getLeftBorderColor();
        result = result * 59 + this.getTopBorderColor();
        result = result * 59 + this.getRightBorderColor();
        return result;
    }

    public String toString() {
        return "ExcelStyle(font=" + this.getFont() + ", horizontalAlignment=" + this.getHorizontalAlignment() + ", verticalAlignment=" + this.getVerticalAlignment() + ", hidden=" + this.isHidden() + ", wrapText=" + this.isWrapText() + ", locked=" + this.isLocked() + ", quotePrefix=" + this.isQuotePrefix() + ", shrinkToFit=" + this.isShrinkToFit() + ", indent=" + this.getIndent() + ", rotation=" + this.getRotation() + ", bgColor=" + this.getBgColor() + ", fgColor=" + this.getFgColor() + ", fillPattern=" + this.getFillPattern() + ", borderBottom=" + this.getBorderBottom() + ", borderLeft=" + this.getBorderLeft() + ", borderTop=" + this.getBorderTop() + ", borderRight=" + this.getBorderRight() + ", bottomBorderColor=" + this.getBottomBorderColor() + ", leftBorderColor=" + this.getLeftBorderColor() + ", topBorderColor=" + this.getTopBorderColor() + ", rightBorderColor=" + this.getRightBorderColor() + ")";
    }
}

