/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.util;

import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.dreamcat.jwrap.excel.content.ExcelBooleanContent;
import org.dreamcat.jwrap.excel.content.ExcelNumericContent;
import org.dreamcat.jwrap.excel.content.ExcelStringContent;
import org.dreamcat.jwrap.excel.content.IExcelContent;
import org.dreamcat.jwrap.excel.core.ExcelCell;
import org.dreamcat.jwrap.excel.core.ExcelSheet;
import org.dreamcat.jwrap.excel.core.ExcelWorkbook;
import org.dreamcat.jwrap.excel.core.IExcelCell;
import org.dreamcat.jwrap.excel.style.ExcelFont;
import org.dreamcat.jwrap.excel.style.ExcelHyperLink;
import org.dreamcat.jwrap.excel.style.ExcelStyle;

public final class ExcelBuilder {
    private ExcelBuilder() {
    }

    public static SheetTerm sheet(String sheetName) {
        return new SheetTerm(new ExcelSheet(sheetName));
    }

    public static WorkbookTerm workbook() {
        ExcelWorkbook<ExcelSheet> book = new ExcelWorkbook<ExcelSheet>();
        return new WorkbookTerm(book);
    }

    public static IExcelContent term(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return new ExcelNumericContent(number.doubleValue());
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return new ExcelBooleanContent(bool);
        }
        if (value instanceof IExcelContent) {
            return (IExcelContent)value;
        }
        return ExcelStringContent.from(value == null ? "" : value.toString());
    }

    public static IExcelContent term(String string) {
        return ExcelStringContent.from(string);
    }

    public static IExcelContent term(double number) {
        return new ExcelNumericContent(number);
    }

    public static ExcelCell term(String string, int rowIndex, int columnIndex) {
        return new ExcelCell(ExcelBuilder.term(string), rowIndex, columnIndex);
    }

    public static ExcelCell term(String string, int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
        return new ExcelCell(ExcelBuilder.term(string), rowIndex, columnIndex, rowSpan, columnSpan);
    }

    public static class CellTerm {
        private final SheetTerm sheetTerm;
        private final ExcelCell cell;
        private ExcelFont font;
        private ExcelStyle style;

        public CellTerm(SheetTerm sheetTerm, ExcelCell cell) {
            this.sheetTerm = sheetTerm;
            this.cell = cell;
        }

        public SheetTerm finishCell() {
            if (this.style == null && this.font == null) {
                return this.sheetTerm;
            }
            if (this.style == null) {
                this.style = new ExcelStyle();
            }
            if (this.font != null) {
                this.style.setFont(this.font);
            }
            this.cell.setStyle(this.style);
            return this.sheetTerm;
        }

        public CellTerm hyperLink(String address) {
            return this.hyperLink(address, null);
        }

        public CellTerm hyperLink(String address, String label) {
            return this.hyperLink(address, label, HyperlinkType.URL);
        }

        public CellTerm hyperLink(String address, String label, HyperlinkType type) {
            this.cell.setHyperLink(new ExcelHyperLink(type, address, label));
            return this;
        }

        public CellTerm bold() {
            return this.bold(true);
        }

        public CellTerm bold(boolean bold) {
            this.getFont().setBold(bold);
            return this;
        }

        public CellTerm italic() {
            return this.italic(true);
        }

        public CellTerm italic(boolean italic) {
            this.getFont().setItalic(italic);
            return this;
        }

        public CellTerm underline() {
            return this.underline((byte)1);
        }

        public CellTerm underline(byte underline) {
            this.getFont().setUnderline(underline);
            return this;
        }

        public CellTerm strikeout() {
            return this.strikeout(true);
        }

        public CellTerm strikeout(boolean strikeout) {
            this.getFont().setStrikeout(strikeout);
            return this;
        }

        public CellTerm typeOffset() {
            return this.typeOffset((short)0);
        }

        public CellTerm typeOffset(short typeOffset) {
            this.getFont().setTypeOffset(typeOffset);
            return this;
        }

        public CellTerm color() {
            return this.color((short)Short.MAX_VALUE);
        }

        public CellTerm color(short color) {
            this.getFont().setColor(color);
            return this;
        }

        public CellTerm height(int height) {
            this.getFont().setHeight((short)height);
            return this;
        }

        public CellTerm horizontalAlignment(HorizontalAlignment horizontalAlignment) {
            this.getStyle().setHorizontalAlignment(horizontalAlignment);
            return this;
        }

        public CellTerm verticalAlignment(VerticalAlignment verticalAlignment) {
            this.getStyle().setVerticalAlignment(verticalAlignment);
            return this;
        }

        public CellTerm hidden() {
            return this.hidden(true);
        }

        public CellTerm hidden(boolean hidden) {
            this.getStyle().setHidden(hidden);
            return this;
        }

        public CellTerm wrapText() {
            return this.wrapText(true);
        }

        public CellTerm wrapText(boolean wrapText) {
            this.getStyle().setWrapText(wrapText);
            return this;
        }

        public CellTerm locked() {
            return this.locked(true);
        }

        public CellTerm locked(boolean locked) {
            this.getStyle().setLocked(locked);
            return this;
        }

        public CellTerm quotePrefix() {
            return this.quotePrefix(true);
        }

        public CellTerm quotePrefix(boolean quotePrefix) {
            this.getStyle().setQuotePrefix(quotePrefix);
            return this;
        }

        public CellTerm shrinkToFit() {
            return this.shrinkToFit(true);
        }

        public CellTerm shrinkToFit(boolean shrinkToFit) {
            this.getStyle().setShrinkToFit(shrinkToFit);
            return this;
        }

        public CellTerm rotation(short rotation) {
            this.getStyle().setRotation(rotation);
            return this;
        }

        public CellTerm bgColor(short bgColor) {
            this.getStyle().setBgColor(bgColor);
            return this;
        }

        public CellTerm fgColor(short fgColor) {
            this.getStyle().setFgColor(fgColor);
            return this;
        }

        public CellTerm fillPattern(FillPatternType fillPatternType) {
            this.getStyle().setFillPattern(fillPatternType);
            return this;
        }

        public CellTerm borderBottom(BorderStyle borderBottom) {
            this.getStyle().setBorderBottom(borderBottom);
            return this;
        }

        public CellTerm borderLeft(BorderStyle borderLeft) {
            this.getStyle().setBorderLeft(borderLeft);
            return this;
        }

        public CellTerm borderTop(BorderStyle borderTop) {
            this.getStyle().setBorderTop(borderTop);
            return this;
        }

        public CellTerm borderRight(BorderStyle borderRight) {
            this.getStyle().setBorderRight(borderRight);
            return this;
        }

        public CellTerm bottomBorderColor(short bottomBorderColor) {
            this.getStyle().setBottomBorderColor(bottomBorderColor);
            return this;
        }

        public CellTerm leftBorderColor(short leftBorderColor) {
            this.getStyle().setLeftBorderColor(leftBorderColor);
            return this;
        }

        public CellTerm topBorderColor(short topBorderColor) {
            this.getStyle().setTopBorderColor(topBorderColor);
            return this;
        }

        public CellTerm rightBorderColor(short rightBorderColor) {
            this.getStyle().setRightBorderColor(rightBorderColor);
            return this;
        }

        private ExcelFont getFont() {
            if (this.font == null) {
                this.font = new ExcelFont();
            }
            return this.font;
        }

        private ExcelStyle getStyle() {
            if (this.style == null) {
                this.style = new ExcelStyle();
            }
            return this.style;
        }
    }

    public static class SheetTerm {
        private final ExcelSheet sheet;

        public ExcelSheet finish() {
            return this.sheet;
        }

        public SheetTerm cell(IExcelCell cell) {
            this.sheet.getCells().add(cell);
            return this;
        }

        public SheetTerm cell(IExcelContent term, int rowIndex, int columnIndex) {
            return this.cell(term, rowIndex, columnIndex, 1, 1);
        }

        public SheetTerm cell(double number, int rowIndex, int columnIndex) {
            return this.cell(ExcelBuilder.term(number), rowIndex, columnIndex);
        }

        public SheetTerm cell(double number, int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
            return this.cell(ExcelBuilder.term(number), rowIndex, columnIndex, rowSpan, columnSpan);
        }

        public SheetTerm cell(String string, int rowIndex, int columnIndex) {
            return this.cell(ExcelBuilder.term(string), rowIndex, columnIndex);
        }

        public SheetTerm cell(String string, int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
            return this.cell(ExcelBuilder.term(string), rowIndex, columnIndex, rowSpan, columnSpan);
        }

        public SheetTerm cell(IExcelContent term, int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
            this.sheet.getCells().add(new ExcelCell(term, rowIndex, columnIndex, rowSpan, columnSpan));
            return this;
        }

        public CellTerm richCell(String string, int rowIndex, int columnIndex) {
            return this.richCell(ExcelBuilder.term(string), rowIndex, columnIndex, 1, 1);
        }

        public CellTerm richCell(double number, int rowIndex, int columnIndex) {
            return this.richCell(ExcelBuilder.term(number), rowIndex, columnIndex, 1, 1);
        }

        public CellTerm richCell(IExcelContent term, int rowIndex, int columnIndex) {
            return this.richCell(term, rowIndex, columnIndex, 1, 1);
        }

        public CellTerm richCell(String string, int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
            return this.richCell(ExcelBuilder.term(string), rowIndex, columnIndex, rowSpan, columnSpan);
        }

        public CellTerm richCell(double number, int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
            return this.richCell(ExcelBuilder.term(number), rowIndex, columnIndex, rowSpan, columnSpan);
        }

        public CellTerm richCell(IExcelContent term, int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
            ExcelCell cell = new ExcelCell(term, rowIndex, columnIndex, rowSpan, columnSpan);
            this.sheet.getCells().add(cell);
            return new CellTerm(this, cell);
        }

        public SheetTerm(ExcelSheet sheet) {
            this.sheet = sheet;
        }
    }

    public static class WorkbookTerm {
        private final ExcelWorkbook<ExcelSheet> book;

        public WorkbookTerm sheet(SheetTerm sheetTerm) {
            return this.sheet(sheetTerm.finish());
        }

        public WorkbookTerm sheet(ExcelSheet sheet) {
            this.book.getSheets().add(sheet);
            return this;
        }

        public ExcelWorkbook<ExcelSheet> finish() {
            return this.book;
        }

        public WorkbookTerm(ExcelWorkbook<ExcelSheet> book) {
            this.book = book;
        }
    }
}

