/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.jwrap.excel.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dreamcat.common.util.ArrayUtil;
import org.dreamcat.common.util.StringUtil;
import org.dreamcat.jwrap.excel.content.IExcelContent;

public final class ExcelMapper {
    private ExcelMapper() {
    }

    public static List<List<List<String>>> parseAsString(String filename) throws IOException, InvalidFormatException {
        return ArrayUtil.map(ExcelMapper.parse(filename), list -> list == null ? null : list.stream().map(StringUtil::string).collect(Collectors.toList()));
    }

    public static List<List<List<String>>> parseAsString(File file) throws IOException, InvalidFormatException {
        return ArrayUtil.map(ExcelMapper.parse(file), list -> list == null ? null : list.stream().map(StringUtil::string).collect(Collectors.toList()));
    }

    public static List<List<List<String>>> parseAsString(InputStream input) throws IOException {
        return ArrayUtil.map(ExcelMapper.parse(input), list -> list == null ? null : list.stream().map(StringUtil::string).collect(Collectors.toList()));
    }

    public static List<List<List<String>>> parseAsString(Workbook workbook) {
        return ArrayUtil.map(ExcelMapper.parse(workbook), list -> list == null ? null : list.stream().map(StringUtil::string).collect(Collectors.toList()));
    }

    public static List<List<String>> parseAsString(String filename, int sheetIndex) throws IOException, InvalidFormatException {
        return ArrayUtil.map(ExcelMapper.parse(filename, sheetIndex), StringUtil::string);
    }

    public static List<List<String>> parseAsString(File file, int sheetIndex) throws IOException, InvalidFormatException {
        return ArrayUtil.map(ExcelMapper.parse(file, sheetIndex), StringUtil::string);
    }

    public static List<List<String>> parseAsString(InputStream input, int sheetIndex) throws IOException {
        return ArrayUtil.map(ExcelMapper.parse(input, sheetIndex), StringUtil::string);
    }

    public static List<List<String>> parseAsString(String filename, String sheetName) throws IOException, InvalidFormatException {
        return ArrayUtil.map(ExcelMapper.parse(filename, sheetName), StringUtil::string);
    }

    public static List<List<String>> parseAsString(File file, String sheetName) throws IOException, InvalidFormatException {
        return ArrayUtil.map(ExcelMapper.parse(file, sheetName), StringUtil::string);
    }

    public static List<List<String>> parseAsString(InputStream input, String sheetName) throws IOException {
        return ArrayUtil.map(ExcelMapper.parse(input, sheetName), StringUtil::string);
    }

    public static List<List<String>> parseAsString(Workbook workbook, int sheetIndex) {
        return ArrayUtil.map(ExcelMapper.parse(workbook, sheetIndex), StringUtil::string);
    }

    public static List<List<String>> parseAsString(Workbook workbook, String sheetName) {
        return ArrayUtil.map(ExcelMapper.parse(workbook, sheetName), StringUtil::string);
    }

    public static List<List<String>> parseAsString(Sheet sheet) {
        return ArrayUtil.map(ExcelMapper.parse(sheet), StringUtil::string);
    }

    public static List<List<List<Object>>> parse(String filename) throws IOException, InvalidFormatException {
        return ExcelMapper.parse(new File(filename));
    }

    public static List<List<List<Object>>> parse(File file) throws IOException, InvalidFormatException {
        try (XSSFWorkbook workbook = new XSSFWorkbook(file);){
            List<List<List<Object>>> list = ExcelMapper.parse((Workbook)workbook);
            return list;
        }
    }

    public static List<List<List<Object>>> parse(InputStream input) throws IOException {
        try (XSSFWorkbook workbook = new XSSFWorkbook(input);){
            List<List<List<Object>>> list = ExcelMapper.parse((Workbook)workbook);
            return list;
        }
    }

    public static List<List<List<Object>>> parse(Workbook workbook) {
        int sheetNum = workbook.getNumberOfSheets();
        ArrayList<List<List<Object>>> sheets = new ArrayList<List<List<Object>>>(sheetNum);
        if (sheetNum == 0) {
            return sheets;
        }
        for (int i = 0; i < sheetNum; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            sheets.add(ExcelMapper.parse(sheet));
        }
        return sheets;
    }

    public static List<List<Object>> parse(String filename, int sheetIndex) throws IOException, InvalidFormatException {
        return ExcelMapper.parse(new File(filename), sheetIndex);
    }

    public static List<List<Object>> parse(File file, int sheetIndex) throws IOException, InvalidFormatException {
        try (XSSFWorkbook workbook = new XSSFWorkbook(file);){
            List<List<Object>> list = ExcelMapper.parse((Workbook)workbook, sheetIndex);
            return list;
        }
    }

    public static List<List<Object>> parse(InputStream input, int sheetIndex) throws IOException {
        try (XSSFWorkbook workbook = new XSSFWorkbook(input);){
            List<List<Object>> list = ExcelMapper.parse((Workbook)workbook, sheetIndex);
            return list;
        }
    }

    public static List<List<Object>> parse(String filename, String sheetName) throws IOException, InvalidFormatException {
        return ExcelMapper.parse(new File(filename), sheetName);
    }

    public static List<List<Object>> parse(File file, String sheetName) throws IOException, InvalidFormatException {
        try (XSSFWorkbook workbook = new XSSFWorkbook(file);){
            List<List<Object>> list = ExcelMapper.parse((Workbook)workbook, sheetName);
            return list;
        }
    }

    public static List<List<Object>> parse(InputStream input, String sheetName) throws IOException {
        try (XSSFWorkbook workbook = new XSSFWorkbook(input);){
            List<List<Object>> list = ExcelMapper.parse((Workbook)workbook, sheetName);
            return list;
        }
    }

    public static List<List<Object>> parse(Workbook workbook, int sheetIndex) {
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        if (sheet == null) {
            return null;
        }
        return ExcelMapper.parse(sheet);
    }

    public static List<List<Object>> parse(Workbook workbook, String sheetName) {
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            return null;
        }
        return ExcelMapper.parse(sheet);
    }

    public static List<List<Object>> parse(Sheet sheet) {
        int rowNum = sheet.getLastRowNum();
        ArrayList<List<Object>> rowValues = new ArrayList<List<Object>>();
        for (int i = 0; i <= rowNum; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                rowValues.add(null);
                continue;
            }
            int end = row.getLastCellNum();
            ArrayList<Object> columnValues = new ArrayList<Object>();
            for (int j = 0; j < end; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    columnValues.add(null);
                    continue;
                }
                columnValues.add(IExcelContent.valueOf(cell));
            }
            rowValues.add(columnValues);
        }
        return rowValues;
    }
}

