/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.drjekyll.matomo.tracker.CommonPoolRunnable;

class DelayedExecutor
implements Executor {
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final long delayInMillis;

    @Override
    public void execute(Runnable command) {
        this.scheduledThreadPoolExecutor.schedule(new CommonPoolRunnable(command), this.delayInMillis, TimeUnit.MILLISECONDS);
    }

    public DelayedExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long delayInMillis) {
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.delayInMillis = delayInMillis;
    }
}

