/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import lombok.NonNull;
import org.drjekyll.matomo.tracker.Action;
import org.drjekyll.matomo.tracker.DaemonThreadFactory;
import org.drjekyll.matomo.tracker.DelayedExecutor;
import org.drjekyll.matomo.tracker.QueryCreator;
import org.drjekyll.matomo.tracker.Sender;
import org.drjekyll.matomo.tracker.TrackerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatomoTracker {
    private static final Logger log = LoggerFactory.getLogger(MatomoTracker.class);
    private final TrackerConfiguration trackerConfiguration;
    private final Sender sender;

    public MatomoTracker(TrackerConfiguration trackerConfiguration) {
        this.trackerConfiguration = trackerConfiguration;
        DaemonThreadFactory threadFactory = new DaemonThreadFactory();
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
        scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        DelayedExecutor delayedExecutor = new DelayedExecutor(scheduledThreadPoolExecutor, trackerConfiguration.getDelay().toMillis());
        this.sender = new Sender(trackerConfiguration, new QueryCreator(trackerConfiguration), delayedExecutor);
    }

    public CompletableFuture<Void> track(@NonNull Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (this.trackerConfiguration.isEnabled()) {
            this.validateSiteId(action);
            return this.sender.send(action);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void validateSiteId(Action action) {
        if (this.trackerConfiguration.getDefaultSiteId() == null && action.getSiteId() == null) {
            throw new IllegalArgumentException("No default site id and not action site id is given");
        }
        if (action.getSiteId() != null && action.getSiteId() < 0) {
            throw new IllegalArgumentException("Site ID must not be negative");
        }
    }
}

