/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.annotation.Nullable;
import lombok.NonNull;

final class ProxyAuthenticator
extends Authenticator {
    @NonNull
    private final String user;
    @NonNull
    private final String password;

    @Override
    @Nullable
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
        return null;
    }

    public ProxyAuthenticator(@NonNull String user, @NonNull String password) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.user = user;
        this.password = password;
    }
}

