/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.drjekyll.matomo.tracker.Action;
import org.drjekyll.matomo.tracker.InitializationFailedException;
import org.drjekyll.matomo.tracker.ParameterException;
import org.drjekyll.matomo.tracker.TrackerConfiguration;
import org.drjekyll.matomo.tracker.TrackingParameter;
import org.drjekyll.matomo.tracker.TrackingParameterMethod;

class QueryCreator {
    private static final List<TrackingParameterMethod> TRACKING_PARAMETER_METHODS = QueryCreator.initializeTrackingParameterMethods();
    private final TrackerConfiguration trackerConfiguration;

    public String createQuery(Action action) {
        StringBuilder query = new StringBuilder("rec=1");
        if (action.getSiteId() == null) {
            query.append("&idsite=").append(this.trackerConfiguration.getDefaultSiteId());
        }
        if (this.trackerConfiguration.getDefaultTokenAuth() != null && (action.getTokenAuth() == null || action.getTokenAuth().trim().isEmpty())) {
            query.append("&token_auth=").append(this.trackerConfiguration.getDefaultTokenAuth());
        }
        for (TrackingParameterMethod method : TRACKING_PARAMETER_METHODS) {
            QueryCreator.appendParameter(method, action, query);
        }
        return query.toString();
    }

    private static void appendParameter(TrackingParameterMethod method, Action action, StringBuilder query) {
        try {
            Object parameterValue = method.getMethod().invoke((Object)action, new Object[0]);
            if (parameterValue != null) {
                method.validateParameterValue(parameterValue);
                query.append('&').append(method.getParameterName()).append('=');
                if (parameterValue instanceof Boolean) {
                    query.append((Boolean)parameterValue != false ? (char)'1' : '0');
                } else {
                    query.append(URLEncoder.encode(parameterValue.toString(), "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException | IllegalAccessException | InvocationTargetException e) {
            throw new ParameterException(e);
        }
    }

    private static List<TrackingParameterMethod> initializeTrackingParameterMethods() {
        ArrayList<TrackingParameterMethod> methods = new ArrayList<TrackingParameterMethod>(32);
        for (Field field : Action.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(TrackingParameter.class)) continue;
            QueryCreator.addMethods(methods, field, field.getAnnotation(TrackingParameter.class));
        }
        return methods;
    }

    private static void addMethods(Collection<TrackingParameterMethod> methods, Member member, TrackingParameter trackingParameter) {
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(Action.class).getPropertyDescriptors()) {
                if (!member.getName().equals(pd.getName())) continue;
                String regex = trackingParameter.regex();
                methods.add(TrackingParameterMethod.builder().parameterName(trackingParameter.name()).method(pd.getReadMethod()).pattern(regex == null || regex.trim().isEmpty() ? null : Pattern.compile(trackingParameter.regex())).build());
            }
        }
        catch (IntrospectionException e) {
            throw new InitializationFailedException("Could not initialize read methods", e);
        }
    }

    public QueryCreator(TrackerConfiguration trackerConfiguration) {
        this.trackerConfiguration = trackerConfiguration;
    }
}

