/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.drjekyll.matomo.tracker.Action;
import org.drjekyll.matomo.tracker.ConnectionFailedException;
import org.drjekyll.matomo.tracker.ProxyAuthenticator;
import org.drjekyll.matomo.tracker.QueryCreator;
import org.drjekyll.matomo.tracker.TrackerConfiguration;
import org.drjekyll.matomo.tracker.TrackingFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Sender {
    private static final Logger log = LoggerFactory.getLogger(Sender.class);
    private final TrackerConfiguration trackerConfiguration;
    private final QueryCreator queryCreator;
    private final Collection<String> queries = new ArrayList<String>(16);
    private final Executor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> send(Action action) {
        Collection<String> collection = this.queries;
        synchronized (collection) {
            String query = this.queryCreator.createQuery(action);
            this.queries.add(query);
        }
        return CompletableFuture.supplyAsync(this::sendRequest, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void sendRequest() {
        Collection<String> collection = this.queries;
        synchronized (collection) {
            if (!this.queries.isEmpty()) {
                HttpURLConnection connection = this.openConnection();
                this.prepareConnection(connection);
                log.debug("Sending bulk request using URI {} asynchronously", (Object)this.trackerConfiguration.getApiEndpoint());
                OutputStream outputStream = null;
                try {
                    connection.connect();
                    outputStream = connection.getOutputStream();
                    outputStream.write(this.createPayload());
                    outputStream.flush();
                    if (connection.getResponseCode() > 399) {
                        if (this.trackerConfiguration.isLogFailedTracking()) {
                            log.error("Received error code {}", (Object)connection.getResponseCode());
                        }
                        throw new TrackingFailedException("Tracking endpoint responded with code " + connection.getResponseCode());
                    }
                    this.queries.clear();
                }
                catch (IOException e) {
                    throw new ConnectionFailedException(e);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    connection.disconnect();
                }
            }
            return null;
        }
    }

    private HttpURLConnection openConnection() {
        try {
            if (Sender.isEmpty(this.trackerConfiguration.getProxyHost()) || this.trackerConfiguration.getProxyPort() <= 0) {
                log.debug("Proxy host or proxy port not configured. Will create connection without proxy");
                return (HttpURLConnection)this.trackerConfiguration.getApiEndpoint().toURL().openConnection();
            }
            InetSocketAddress proxyAddress = new InetSocketAddress(this.trackerConfiguration.getProxyHost(), this.trackerConfiguration.getProxyPort());
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyAddress);
            if (!Sender.isEmpty(this.trackerConfiguration.getProxyUserName()) && !Sender.isEmpty(this.trackerConfiguration.getProxyPassword())) {
                Authenticator.setDefault(new ProxyAuthenticator(this.trackerConfiguration.getProxyUserName(), this.trackerConfiguration.getProxyPassword()));
            }
            return (HttpURLConnection)this.trackerConfiguration.getApiEndpoint().toURL().openConnection(proxy);
        }
        catch (IOException e) {
            throw new ConnectionFailedException(e);
        }
    }

    private void prepareConnection(HttpURLConnection connection) {
        try {
            connection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new TrackingFailedException("Could not set request method", e);
        }
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", this.trackerConfiguration.getUserAgent());
        if (this.trackerConfiguration.getConnectTimeout() != null) {
            connection.setConnectTimeout((int)this.trackerConfiguration.getConnectTimeout().toMillis());
        }
        if (this.trackerConfiguration.getSocketTimeout() != null) {
            connection.setReadTimeout((int)this.trackerConfiguration.getSocketTimeout().toMillis());
        }
    }

    private byte[] createPayload() {
        StringBuilder payload = new StringBuilder("{\"requests\":[");
        Iterator<String> iterator = this.queries.iterator();
        while (iterator.hasNext()) {
            String query = iterator.next();
            payload.append("\"?").append(query).append('\"');
            if (!iterator.hasNext()) continue;
            payload.append(',');
        }
        payload.append(']');
        if (this.trackerConfiguration.getDefaultTokenAuth() != null) {
            payload.append(",\"token_auth\":\"").append(this.trackerConfiguration.getDefaultTokenAuth()).append('\"');
        }
        payload.append('}');
        return payload.toString().getBytes(StandardCharsets.UTF_8);
    }

    private static boolean isEmpty(@Nullable String str) {
        return str == null || str.trim().isEmpty();
    }

    public Sender(TrackerConfiguration trackerConfiguration, QueryCreator queryCreator, Executor executor) {
        this.trackerConfiguration = trackerConfiguration;
        this.queryCreator = queryCreator;
        this.executor = executor;
    }
}

