/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker;

import java.net.URI;
import java.time.Duration;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class TrackerConfiguration {
    @NonNull
    private final URI apiEndpoint;
    private final Integer defaultSiteId;
    private final String defaultTokenAuth;
    @NonNull
    private final Duration delay;
    private final boolean enabled;
    private final Duration connectTimeout;
    private final Duration socketTimeout;
    @Nullable
    private final String proxyHost;
    private final int proxyPort;
    @Nullable
    private final String proxyUserName;
    @Nullable
    private final String proxyPassword;
    @NonNull
    private final String userAgent;
    private final boolean logFailedTracking;

    private static Duration $default$delay() {
        return Duration.ofSeconds(1L);
    }

    private static boolean $default$enabled() {
        return true;
    }

    private static Duration $default$connectTimeout() {
        return Duration.ofSeconds(10L);
    }

    private static Duration $default$socketTimeout() {
        return Duration.ofSeconds(30L);
    }

    private static String $default$userAgent() {
        return "MatomoJavaClient";
    }

    TrackerConfiguration(@NonNull URI apiEndpoint, Integer defaultSiteId, String defaultTokenAuth, @NonNull Duration delay, boolean enabled, Duration connectTimeout, Duration socketTimeout, @Nullable String proxyHost, int proxyPort, @Nullable String proxyUserName, @Nullable String proxyPassword, @NonNull String userAgent, boolean logFailedTracking) {
        if (apiEndpoint == null) {
            throw new NullPointerException("apiEndpoint is marked non-null but is null");
        }
        if (delay == null) {
            throw new NullPointerException("delay is marked non-null but is null");
        }
        if (userAgent == null) {
            throw new NullPointerException("userAgent is marked non-null but is null");
        }
        this.apiEndpoint = apiEndpoint;
        this.defaultSiteId = defaultSiteId;
        this.defaultTokenAuth = defaultTokenAuth;
        this.delay = delay;
        this.enabled = enabled;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUserName = proxyUserName;
        this.proxyPassword = proxyPassword;
        this.userAgent = userAgent;
        this.logFailedTracking = logFailedTracking;
    }

    public static TrackerConfigurationBuilder builder() {
        return new TrackerConfigurationBuilder();
    }

    @NonNull
    public URI getApiEndpoint() {
        return this.apiEndpoint;
    }

    public Integer getDefaultSiteId() {
        return this.defaultSiteId;
    }

    public String getDefaultTokenAuth() {
        return this.defaultTokenAuth;
    }

    @NonNull
    public Duration getDelay() {
        return this.delay;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    @Nullable
    public String getProxyUserName() {
        return this.proxyUserName;
    }

    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @NonNull
    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isLogFailedTracking() {
        return this.logFailedTracking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackerConfiguration)) {
            return false;
        }
        TrackerConfiguration other = (TrackerConfiguration)o;
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getProxyPort() != other.getProxyPort()) {
            return false;
        }
        if (this.isLogFailedTracking() != other.isLogFailedTracking()) {
            return false;
        }
        Integer this$defaultSiteId = this.getDefaultSiteId();
        Integer other$defaultSiteId = other.getDefaultSiteId();
        if (this$defaultSiteId == null ? other$defaultSiteId != null : !((Object)this$defaultSiteId).equals(other$defaultSiteId)) {
            return false;
        }
        URI this$apiEndpoint = this.getApiEndpoint();
        URI other$apiEndpoint = other.getApiEndpoint();
        if (this$apiEndpoint == null ? other$apiEndpoint != null : !((Object)this$apiEndpoint).equals(other$apiEndpoint)) {
            return false;
        }
        String this$defaultTokenAuth = this.getDefaultTokenAuth();
        String other$defaultTokenAuth = other.getDefaultTokenAuth();
        if (this$defaultTokenAuth == null ? other$defaultTokenAuth != null : !this$defaultTokenAuth.equals(other$defaultTokenAuth)) {
            return false;
        }
        Duration this$delay = this.getDelay();
        Duration other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$socketTimeout = this.getSocketTimeout();
        Duration other$socketTimeout = other.getSocketTimeout();
        if (this$socketTimeout == null ? other$socketTimeout != null : !((Object)this$socketTimeout).equals(other$socketTimeout)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        String this$proxyUserName = this.getProxyUserName();
        String other$proxyUserName = other.getProxyUserName();
        if (this$proxyUserName == null ? other$proxyUserName != null : !this$proxyUserName.equals(other$proxyUserName)) {
            return false;
        }
        String this$proxyPassword = this.getProxyPassword();
        String other$proxyPassword = other.getProxyPassword();
        if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getProxyPort();
        result = result * 59 + (this.isLogFailedTracking() ? 79 : 97);
        Integer $defaultSiteId = this.getDefaultSiteId();
        result = result * 59 + ($defaultSiteId == null ? 43 : ((Object)$defaultSiteId).hashCode());
        URI $apiEndpoint = this.getApiEndpoint();
        result = result * 59 + ($apiEndpoint == null ? 43 : ((Object)$apiEndpoint).hashCode());
        String $defaultTokenAuth = this.getDefaultTokenAuth();
        result = result * 59 + ($defaultTokenAuth == null ? 43 : $defaultTokenAuth.hashCode());
        Duration $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $socketTimeout = this.getSocketTimeout();
        result = result * 59 + ($socketTimeout == null ? 43 : ((Object)$socketTimeout).hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        String $proxyUserName = this.getProxyUserName();
        result = result * 59 + ($proxyUserName == null ? 43 : $proxyUserName.hashCode());
        String $proxyPassword = this.getProxyPassword();
        result = result * 59 + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        return result;
    }

    public String toString() {
        return "TrackerConfiguration(apiEndpoint=" + this.getApiEndpoint() + ", defaultSiteId=" + this.getDefaultSiteId() + ", defaultTokenAuth=" + this.getDefaultTokenAuth() + ", delay=" + this.getDelay() + ", enabled=" + this.isEnabled() + ", connectTimeout=" + this.getConnectTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", proxyUserName=" + this.getProxyUserName() + ", proxyPassword=" + this.getProxyPassword() + ", userAgent=" + this.getUserAgent() + ", logFailedTracking=" + this.isLogFailedTracking() + ")";
    }

    public static class TrackerConfigurationBuilder {
        private URI apiEndpoint;
        private Integer defaultSiteId;
        private String defaultTokenAuth;
        private boolean delay$set;
        private Duration delay$value;
        private boolean enabled$set;
        private boolean enabled$value;
        private boolean connectTimeout$set;
        private Duration connectTimeout$value;
        private boolean socketTimeout$set;
        private Duration socketTimeout$value;
        private String proxyHost;
        private int proxyPort;
        private String proxyUserName;
        private String proxyPassword;
        private boolean userAgent$set;
        private String userAgent$value;
        private boolean logFailedTracking;

        TrackerConfigurationBuilder() {
        }

        public TrackerConfigurationBuilder apiEndpoint(@NonNull URI apiEndpoint) {
            if (apiEndpoint == null) {
                throw new NullPointerException("apiEndpoint is marked non-null but is null");
            }
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public TrackerConfigurationBuilder defaultSiteId(Integer defaultSiteId) {
            this.defaultSiteId = defaultSiteId;
            return this;
        }

        public TrackerConfigurationBuilder defaultTokenAuth(String defaultTokenAuth) {
            this.defaultTokenAuth = defaultTokenAuth;
            return this;
        }

        public TrackerConfigurationBuilder delay(@NonNull Duration delay) {
            if (delay == null) {
                throw new NullPointerException("delay is marked non-null but is null");
            }
            this.delay$value = delay;
            this.delay$set = true;
            return this;
        }

        public TrackerConfigurationBuilder enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        public TrackerConfigurationBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        public TrackerConfigurationBuilder socketTimeout(Duration socketTimeout) {
            this.socketTimeout$value = socketTimeout;
            this.socketTimeout$set = true;
            return this;
        }

        public TrackerConfigurationBuilder proxyHost(@Nullable String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public TrackerConfigurationBuilder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public TrackerConfigurationBuilder proxyUserName(@Nullable String proxyUserName) {
            this.proxyUserName = proxyUserName;
            return this;
        }

        public TrackerConfigurationBuilder proxyPassword(@Nullable String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public TrackerConfigurationBuilder userAgent(@NonNull String userAgent) {
            if (userAgent == null) {
                throw new NullPointerException("userAgent is marked non-null but is null");
            }
            this.userAgent$value = userAgent;
            this.userAgent$set = true;
            return this;
        }

        public TrackerConfigurationBuilder logFailedTracking(boolean logFailedTracking) {
            this.logFailedTracking = logFailedTracking;
            return this;
        }

        public TrackerConfiguration build() {
            Duration delay$value = this.delay$value;
            if (!this.delay$set) {
                delay$value = TrackerConfiguration.$default$delay();
            }
            boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = TrackerConfiguration.$default$enabled();
            }
            Duration connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = TrackerConfiguration.$default$connectTimeout();
            }
            Duration socketTimeout$value = this.socketTimeout$value;
            if (!this.socketTimeout$set) {
                socketTimeout$value = TrackerConfiguration.$default$socketTimeout();
            }
            String userAgent$value = this.userAgent$value;
            if (!this.userAgent$set) {
                userAgent$value = TrackerConfiguration.$default$userAgent();
            }
            return new TrackerConfiguration(this.apiEndpoint, this.defaultSiteId, this.defaultTokenAuth, delay$value, enabled$value, connectTimeout$value, socketTimeout$value, this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword, userAgent$value, this.logFailedTracking);
        }

        public String toString() {
            return "TrackerConfiguration.TrackerConfigurationBuilder(apiEndpoint=" + this.apiEndpoint + ", defaultSiteId=" + this.defaultSiteId + ", defaultTokenAuth=" + this.defaultTokenAuth + ", delay$value=" + this.delay$value + ", enabled$value=" + this.enabled$value + ", connectTimeout$value=" + this.connectTimeout$value + ", socketTimeout$value=" + this.socketTimeout$value + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyUserName=" + this.proxyUserName + ", proxyPassword=" + this.proxyPassword + ", userAgent$value=" + this.userAgent$value + ", logFailedTracking=" + this.logFailedTracking + ")";
        }
    }
}

