/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker;

import java.lang.reflect.Method;
import java.util.regex.Pattern;

final class TrackingParameterMethod {
    private final String parameterName;
    private final Method method;
    private final Pattern pattern;

    void validateParameterValue(Object parameterValue) {
        if (this.pattern != null && parameterValue instanceof CharSequence && !this.pattern.matcher((CharSequence)parameterValue).matches()) {
            throw new IllegalArgumentException(String.format("Invalid value for %s. Must match regex %s", this.parameterName, this.pattern));
        }
    }

    TrackingParameterMethod(String parameterName, Method method, Pattern pattern) {
        this.parameterName = parameterName;
        this.method = method;
        this.pattern = pattern;
    }

    public static TrackingParameterMethodBuilder builder() {
        return new TrackingParameterMethodBuilder();
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Method getMethod() {
        return this.method;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackingParameterMethod)) {
            return false;
        }
        TrackingParameterMethod other = (TrackingParameterMethod)o;
        String this$parameterName = this.getParameterName();
        String other$parameterName = other.getParameterName();
        if (this$parameterName == null ? other$parameterName != null : !this$parameterName.equals(other$parameterName)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Pattern this$pattern = this.getPattern();
        Pattern other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameterName = this.getParameterName();
        result = result * 59 + ($parameterName == null ? 43 : $parameterName.hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Pattern $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }

    public String toString() {
        return "TrackingParameterMethod(parameterName=" + this.getParameterName() + ", method=" + this.getMethod() + ", pattern=" + this.getPattern() + ")";
    }

    public static class TrackingParameterMethodBuilder {
        private String parameterName;
        private Method method;
        private Pattern pattern;

        TrackingParameterMethodBuilder() {
        }

        public TrackingParameterMethodBuilder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public TrackingParameterMethodBuilder method(Method method) {
            this.method = method;
            return this;
        }

        public TrackingParameterMethodBuilder pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public TrackingParameterMethod build() {
            return new TrackingParameterMethod(this.parameterName, this.method, this.pattern);
        }

        public String toString() {
            return "TrackingParameterMethod.TrackingParameterMethodBuilder(parameterName=" + this.parameterName + ", method=" + this.method + ", pattern=" + this.pattern + ")";
        }
    }
}

