/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker.parameters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class AcceptLanguage {
    private final List<Locale.LanguageRange> languageRanges;

    public String toString() {
        return this.languageRanges.stream().filter(Objects::nonNull).map(AcceptLanguage::format).collect(Collectors.joining(","));
    }

    private static String format(@NonNull Locale.LanguageRange languageRange) {
        if (languageRange == null) {
            throw new NullPointerException("languageRange is marked non-null but is null");
        }
        return languageRange.getWeight() == 1.0 ? languageRange.getRange() : languageRange.getRange() + ";q=" + languageRange.getWeight();
    }

    @Nullable
    public static AcceptLanguage fromHeader(@Nullable String header) {
        if (header == null || header.trim().isEmpty()) {
            return null;
        }
        return new AcceptLanguage(Locale.LanguageRange.parse(header));
    }

    AcceptLanguage(List<Locale.LanguageRange> languageRanges) {
        this.languageRanges = languageRanges;
    }

    public static AcceptLanguageBuilder builder() {
        return new AcceptLanguageBuilder();
    }

    public List<Locale.LanguageRange> getLanguageRanges() {
        return this.languageRanges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceptLanguage)) {
            return false;
        }
        AcceptLanguage other = (AcceptLanguage)o;
        List<Locale.LanguageRange> this$languageRanges = this.getLanguageRanges();
        List<Locale.LanguageRange> other$languageRanges = other.getLanguageRanges();
        return !(this$languageRanges == null ? other$languageRanges != null : !((Object)this$languageRanges).equals(other$languageRanges));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Locale.LanguageRange> $languageRanges = this.getLanguageRanges();
        result = result * 59 + ($languageRanges == null ? 43 : ((Object)$languageRanges).hashCode());
        return result;
    }

    public static class AcceptLanguageBuilder {
        private ArrayList<Locale.LanguageRange> languageRanges;

        AcceptLanguageBuilder() {
        }

        public AcceptLanguageBuilder languageRange(Locale.LanguageRange languageRange) {
            if (this.languageRanges == null) {
                this.languageRanges = new ArrayList();
            }
            this.languageRanges.add(languageRange);
            return this;
        }

        public AcceptLanguageBuilder languageRanges(Collection<? extends Locale.LanguageRange> languageRanges) {
            if (languageRanges == null) {
                throw new NullPointerException("languageRanges cannot be null");
            }
            if (this.languageRanges == null) {
                this.languageRanges = new ArrayList();
            }
            this.languageRanges.addAll(languageRanges);
            return this;
        }

        public AcceptLanguageBuilder clearLanguageRanges() {
            if (this.languageRanges != null) {
                this.languageRanges.clear();
            }
            return this;
        }

        public AcceptLanguage build() {
            List<Locale.LanguageRange> languageRanges;
            switch (this.languageRanges == null ? 0 : this.languageRanges.size()) {
                case 0: {
                    languageRanges = Collections.emptyList();
                    break;
                }
                case 1: {
                    languageRanges = Collections.singletonList(this.languageRanges.get(0));
                    break;
                }
                default: {
                    languageRanges = Collections.unmodifiableList(new ArrayList<Locale.LanguageRange>(this.languageRanges));
                }
            }
            return new AcceptLanguage(languageRanges);
        }

        public String toString() {
            return "AcceptLanguage.AcceptLanguageBuilder(languageRanges=" + this.languageRanges + ")";
        }
    }
}

