/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker.parameters;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import lombok.NonNull;

public class Country {
    @NonNull
    private final String code;

    @Nullable
    public static Country fromCode(@Nullable String code) {
        if (code == null || code.trim().isEmpty()) {
            return null;
        }
        if (code.length() == 2) {
            return new Country(code.toLowerCase(Locale.ROOT));
        }
        throw new IllegalArgumentException("Invalid country code");
    }

    @Nullable
    public static Country fromLanguageRanges(@Nullable String ranges) {
        if (ranges == null) {
            return null;
        }
        List<Locale.LanguageRange> languageRanges = Locale.LanguageRange.parse(ranges);
        for (Locale.LanguageRange languageRange : languageRanges) {
            String range = languageRange.getRange();
            String[] split = range.split("-");
            if (split.length != 2 || split[1].length() != 2) continue;
            return new Country(split[1].toLowerCase(Locale.ROOT));
        }
        throw new IllegalArgumentException("Invalid country code");
    }

    public String toString() {
        return this.code;
    }

    private Country(@NonNull String code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        this.code = code;
    }
}

