/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker.parameters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drjekyll.matomo.tracker.parameters.CustomVariable;

public final class CustomVariables {
    private final List<CustomVariable> variables;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i = 0; i < this.variables.size(); ++i) {
            CustomVariable variable = this.variables.get(i);
            stringBuilder.append('\"').append(i + 1).append("\":[\"").append(variable.getKey()).append("\",\"").append(variable.getValue()).append("\"]");
            if (i == this.variables.size() - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    CustomVariables(List<CustomVariable> variables) {
        this.variables = variables;
    }

    public static CustomVariablesBuilder builder() {
        return new CustomVariablesBuilder();
    }

    public List<CustomVariable> getVariables() {
        return this.variables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomVariables)) {
            return false;
        }
        CustomVariables other = (CustomVariables)o;
        List<CustomVariable> this$variables = this.getVariables();
        List<CustomVariable> other$variables = other.getVariables();
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CustomVariable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }

    public static class CustomVariablesBuilder {
        private ArrayList<CustomVariable> variables;

        CustomVariablesBuilder() {
        }

        public CustomVariablesBuilder variable(CustomVariable variable) {
            if (this.variables == null) {
                this.variables = new ArrayList();
            }
            this.variables.add(variable);
            return this;
        }

        public CustomVariablesBuilder variables(Collection<? extends CustomVariable> variables) {
            if (variables == null) {
                throw new NullPointerException("variables cannot be null");
            }
            if (this.variables == null) {
                this.variables = new ArrayList();
            }
            this.variables.addAll(variables);
            return this;
        }

        public CustomVariablesBuilder clearVariables() {
            if (this.variables != null) {
                this.variables.clear();
            }
            return this;
        }

        public CustomVariables build() {
            List<CustomVariable> variables;
            switch (this.variables == null ? 0 : this.variables.size()) {
                case 0: {
                    variables = Collections.emptyList();
                    break;
                }
                case 1: {
                    variables = Collections.singletonList(this.variables.get(0));
                    break;
                }
                default: {
                    variables = Collections.unmodifiableList(new ArrayList<CustomVariable>(this.variables));
                }
            }
            return new CustomVariables(variables);
        }

        public String toString() {
            return "CustomVariables.CustomVariablesBuilder(variables=" + this.variables + ")";
        }
    }
}

