/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker.parameters;

import java.util.Locale;
import lombok.NonNull;

public final class EcommerceItem {
    @NonNull
    private final String sku;
    @NonNull
    private final String name;
    @NonNull
    private final String category;
    @NonNull
    private final Double price;
    @NonNull
    private final Long quantity;

    public String toString() {
        return String.format(Locale.US, "[\"%s\",\"%s\",\"%s\",%f,%d]", this.sku, this.name, this.category, this.price, this.quantity);
    }

    private static String $default$name() {
        return "";
    }

    private static String $default$category() {
        return "";
    }

    private static Double $default$price() {
        return 0.0;
    }

    private static Long $default$quantity() {
        return 0L;
    }

    EcommerceItem(@NonNull String sku, @NonNull String name, @NonNull String category, @NonNull Double price, @NonNull Long quantity) {
        if (sku == null) {
            throw new NullPointerException("sku is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        if (quantity == null) {
            throw new NullPointerException("quantity is marked non-null but is null");
        }
        this.sku = sku;
        this.name = name;
        this.category = category;
        this.price = price;
        this.quantity = quantity;
    }

    public static EcommerceItemBuilder builder() {
        return new EcommerceItemBuilder();
    }

    @NonNull
    public String getSku() {
        return this.sku;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getCategory() {
        return this.category;
    }

    @NonNull
    public Double getPrice() {
        return this.price;
    }

    @NonNull
    public Long getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EcommerceItem)) {
            return false;
        }
        EcommerceItem other = (EcommerceItem)o;
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$sku = this.getSku();
        String other$sku = other.getSku();
        if (this$sku == null ? other$sku != null : !this$sku.equals(other$sku)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !this$category.equals(other$category));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $sku = this.getSku();
        result = result * 59 + ($sku == null ? 43 : $sku.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        return result;
    }

    public static class EcommerceItemBuilder {
        private String sku;
        private boolean name$set;
        private String name$value;
        private boolean category$set;
        private String category$value;
        private boolean price$set;
        private Double price$value;
        private boolean quantity$set;
        private Long quantity$value;

        EcommerceItemBuilder() {
        }

        public EcommerceItemBuilder sku(@NonNull String sku) {
            if (sku == null) {
                throw new NullPointerException("sku is marked non-null but is null");
            }
            this.sku = sku;
            return this;
        }

        public EcommerceItemBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name$value = name;
            this.name$set = true;
            return this;
        }

        public EcommerceItemBuilder category(@NonNull String category) {
            if (category == null) {
                throw new NullPointerException("category is marked non-null but is null");
            }
            this.category$value = category;
            this.category$set = true;
            return this;
        }

        public EcommerceItemBuilder price(@NonNull Double price) {
            if (price == null) {
                throw new NullPointerException("price is marked non-null but is null");
            }
            this.price$value = price;
            this.price$set = true;
            return this;
        }

        public EcommerceItemBuilder quantity(@NonNull Long quantity) {
            if (quantity == null) {
                throw new NullPointerException("quantity is marked non-null but is null");
            }
            this.quantity$value = quantity;
            this.quantity$set = true;
            return this;
        }

        public EcommerceItem build() {
            String name$value = this.name$value;
            if (!this.name$set) {
                name$value = EcommerceItem.$default$name();
            }
            String category$value = this.category$value;
            if (!this.category$set) {
                category$value = EcommerceItem.$default$category();
            }
            Double price$value = this.price$value;
            if (!this.price$set) {
                price$value = EcommerceItem.$default$price();
            }
            Long quantity$value = this.quantity$value;
            if (!this.quantity$set) {
                quantity$value = EcommerceItem.$default$quantity();
            }
            return new EcommerceItem(this.sku, name$value, category$value, price$value, quantity$value);
        }

        public String toString() {
            return "EcommerceItem.EcommerceItemBuilder(sku=" + this.sku + ", name$value=" + this.name$value + ", category$value=" + this.category$value + ", price$value=" + this.price$value + ", quantity$value=" + this.quantity$value + ")";
        }
    }
}

