/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker.parameters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.drjekyll.matomo.tracker.parameters.EcommerceItem;

public final class EcommerceItems {
    private final List<EcommerceItem> items;

    public String toString() {
        return this.items.stream().map(String::valueOf).collect(Collectors.joining(",", "[", "]"));
    }

    EcommerceItems(List<EcommerceItem> items) {
        this.items = items;
    }

    public static EcommerceItemsBuilder builder() {
        return new EcommerceItemsBuilder();
    }

    public List<EcommerceItem> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EcommerceItems)) {
            return false;
        }
        EcommerceItems other = (EcommerceItems)o;
        List<EcommerceItem> this$items = this.getItems();
        List<EcommerceItem> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EcommerceItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public static class EcommerceItemsBuilder {
        private ArrayList<EcommerceItem> items;

        EcommerceItemsBuilder() {
        }

        public EcommerceItemsBuilder item(EcommerceItem item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        public EcommerceItemsBuilder items(Collection<? extends EcommerceItem> items) {
            if (items == null) {
                throw new NullPointerException("items cannot be null");
            }
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        public EcommerceItemsBuilder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        public EcommerceItems build() {
            List<EcommerceItem> items;
            switch (this.items == null ? 0 : this.items.size()) {
                case 0: {
                    items = Collections.emptyList();
                    break;
                }
                case 1: {
                    items = Collections.singletonList(this.items.get(0));
                    break;
                }
                default: {
                    items = Collections.unmodifiableList(new ArrayList<EcommerceItem>(this.items));
                }
            }
            return new EcommerceItems(items);
        }

        public String toString() {
            return "EcommerceItems.EcommerceItemsBuilder(items=" + this.items + ")";
        }
    }
}

