/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker.parameters;

import java.time.Instant;
import lombok.NonNull;

public class UnixTimestamp {
    private final long seconds;

    public static UnixTimestamp now() {
        return new UnixTimestamp(Instant.now().getEpochSecond());
    }

    public static UnixTimestamp fromInstant(@NonNull Instant instant) {
        if (instant == null) {
            throw new NullPointerException("instant is marked non-null but is null");
        }
        return new UnixTimestamp(instant.getEpochSecond());
    }

    public String toString() {
        return Long.toString(this.seconds);
    }

    public static UnixTimestampBuilder builder() {
        return new UnixTimestampBuilder();
    }

    public UnixTimestamp(long seconds) {
        this.seconds = seconds;
    }

    public static class UnixTimestampBuilder {
        private long seconds;

        UnixTimestampBuilder() {
        }

        public UnixTimestampBuilder seconds(long seconds) {
            this.seconds = seconds;
            return this;
        }

        public UnixTimestamp build() {
            return new UnixTimestamp(this.seconds);
        }

        public String toString() {
            return "UnixTimestamp.UnixTimestampBuilder(seconds=" + this.seconds + ")";
        }
    }
}

