/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.matomo.tracker.parameters;

import java.security.SecureRandom;
import java.util.Random;

public class VisitorId {
    private static final Random RANDOM = new SecureRandom();
    private final byte[] representation = new byte[8];

    public static VisitorId random() {
        VisitorId visitorId = new VisitorId();
        RANDOM.nextBytes(visitorId.representation);
        return visitorId;
    }

    public static VisitorId fromHash(long hash) {
        VisitorId visitorId = new VisitorId();
        for (int i = 0; i < 7; ++i) {
            visitorId.representation[i] = (byte)((long)i + hash & 0xFFL);
            hash >>= 8;
        }
        return visitorId;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (byte b : this.representation) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }
}

