/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.droitateddb.CursorOperation;
import org.droitateddb.EntityData;
import org.droitateddb.SchemaUtil;
import org.droitateddb.Utilities;
import org.droitateddb.cursor.CombinedCursorImpl;
import org.droitateddb.schema.AbstractAttribute;
import org.droitateddb.schema.ToManyAssociation;
import org.droitateddb.schema.ToOneAssociation;

class DatabaseResolver {
    private final Map<String, Object> loadedObjects;
    private final Context context;
    private final SQLiteDatabase database;

    public DatabaseResolver(Context context, SQLiteDatabase database) {
        this.context = context;
        this.database = database;
        this.loadedObjects = new HashMap<String, Object>();
    }

    public void resolve(Object data, int currentDepth, int maxDepth) {
        if (currentDepth >= maxDepth) {
            return;
        }
        EntityData entityData = EntityData.getEntityData(data);
        if (entityData.allAssociations.size() > 0) {
            Class<?> associationsDeclaration = SchemaUtil.getAssociationsSchema(data.getClass());
            Number id = Utilities.getPrimaryKey(data, entityData);
            if (id != null) {
                this.loadedObjects.put("class " + data.getClass().getCanonicalName() + "#" + id, data);
                for (Field associationField : entityData.allAssociations) {
                    Object declaration = DatabaseResolver.getDeclaration(associationsDeclaration, associationField);
                    if (declaration instanceof ToOneAssociation) {
                        this.handleToOneAssociation(id, data, associationField, (ToOneAssociation)declaration, currentDepth, maxDepth);
                        continue;
                    }
                    this.handleToManyAssociation(id, data, associationField, (ToManyAssociation)declaration, currentDepth, maxDepth);
                }
            }
        }
    }

    private void handleToOneAssociation(Number idRequestingObject, final Object requestingObject, final Field associationField, final ToOneAssociation toOneAssociation, final int currentDepth, final int maxDepth) {
        String keyName = EntityData.getEntityData((Object)requestingObject).primaryKey.getName();
        Cursor fkCursor = this.database.query(SchemaUtil.getTableName(requestingObject.getClass()), new String[]{toOneAssociation.getAssociationAttribute().columnName()}, keyName + " = ?", new String[]{idRequestingObject.toString()}, null, null, null);
        CursorOperation.tryOnCursor(fkCursor, new CursorOperation<Void>(){

            @Override
            public Void execute(Cursor cursor) throws Exception {
                if (cursor.moveToFirst() && cursor.getType(0) != 0) {
                    DatabaseResolver.this.attachAssociation(cursor.getLong(0), associationField, requestingObject, toOneAssociation, currentDepth, maxDepth);
                }
                return null;
            }
        });
    }

    private void attachAssociation(long id, Field associationField, Object requestingObject, ToOneAssociation declaration, int currentDepth, int maxDepth) {
        String mixedId = "class " + declaration.getAssociatedType().getCanonicalName() + "#" + id;
        if (this.loadedObjects.containsKey(mixedId)) {
            Utilities.setFieldValue(associationField, requestingObject, this.loadedObjects.get(mixedId));
        } else {
            this.loadFromDatabase(id, associationField, requestingObject, declaration, currentDepth, maxDepth);
        }
    }

    private void loadFromDatabase(final long id, final Field associationField, final Object requestingObject, final ToOneAssociation declaration, final int currentDepth, final int maxDepth) {
        Cursor associationCursor = this.database.query(SchemaUtil.getTableName(declaration.getAssociatedType()), null, EntityData.getEntityData(declaration.getAssociatedType()).primaryKey.getName() + "=?", new String[]{Long.toString(id)}, null, null, null);
        CursorOperation.tryOnCursor(associationCursor, new CursorOperation<Void>(){

            @Override
            public Void execute(Cursor cursor) {
                if (cursor.moveToFirst()) {
                    Object association = CombinedCursorImpl.create(DatabaseResolver.this.context, cursor, SchemaUtil.getEntityInfo(declaration.getAssociatedType()), declaration.getAssociatedType()).getCurrent();
                    Utilities.setFieldValue(associationField, requestingObject, association);
                    DatabaseResolver.this.loadedObjects.put(declaration.getAssociatedType().getCanonicalName() + "#" + id, association);
                    DatabaseResolver.this.resolve(association, currentDepth + 1, maxDepth);
                }
                return null;
            }
        });
    }

    private void handleToManyAssociation(Number primaryKeyData, Object data, Field associationField, ToManyAssociation toMany, final int currentDepth, final int maxDepth) {
        final AbstractAttribute foreignAttribute = this.getForeignAttribute(toMany);
        if (foreignAttribute != null) {
            EntityData entityData = EntityData.getEntityData(foreignAttribute.type());
            if (Utilities.getFieldValue(data, associationField) != null) {
                for (Object object : this.getCollection(data, associationField)) {
                    this.resolve(object, currentDepth + 1, maxDepth);
                    this.loadedObjects.put(foreignAttribute.type() + "#" + Utilities.getPrimaryKey(object, entityData), object);
                }
            }
            ArrayList<Object> target = new ArrayList<Object>();
            Utilities.setFieldValue(associationField, data, target);
            List<Number> ids = this.loadIdsFromLinkTable(primaryKeyData, data.getClass(), foreignAttribute, toMany);
            for (Number id : ids) {
                final String mixedId = foreignAttribute.type() + "#" + id;
                if (this.loadedObjects.containsKey(mixedId)) {
                    target.add(this.loadedObjects.get(mixedId));
                    continue;
                }
                String primaryKeyName = entityData.primaryKey.getName();
                Cursor cursor = this.database.query(SchemaUtil.getTableName(foreignAttribute.type()), null, primaryKeyName + "= ?", new String[]{id.toString()}, null, null, null);
                Object linkedObject = CursorOperation.tryOnCursor(cursor, new CursorOperation<Object>(){

                    @Override
                    public Object execute(Cursor cursor) {
                        if (cursor.getCount() > 0) {
                            Object loaded = CombinedCursorImpl.create(DatabaseResolver.this.context, cursor, SchemaUtil.getEntityInfo(foreignAttribute.type()), foreignAttribute.type()).getOne();
                            DatabaseResolver.this.loadedObjects.put(mixedId, loaded);
                            DatabaseResolver.this.resolve(loaded, currentDepth + 1, maxDepth);
                            return loaded;
                        }
                        return null;
                    }
                });
                if (linkedObject == null) continue;
                target.add(linkedObject);
            }
        }
    }

    private Collection<Object> getCollection(Object data, Field associationField) {
        return new ArrayList<Object>((Collection)Utilities.getFieldValue(data, associationField));
    }

    private AbstractAttribute getForeignAttribute(ToManyAssociation toMany) {
        for (AbstractAttribute attribute : Utilities.getLinkTableColumns(toMany.getLinkTableSchema())) {
            if (!attribute.columnName().endsWith("_to")) continue;
            return attribute;
        }
        return null;
    }

    private List<Number> loadIdsFromLinkTable(Number primaryKeyData, Class<?> dataClass, final AbstractAttribute foreignAttribute, ToManyAssociation toMany) {
        String tableName = Utilities.getLinkTableName(toMany.getLinkTableSchema());
        String columnName = "fk_" + dataClass.getSimpleName().toLowerCase(Locale.getDefault()) + "_from";
        Cursor cursor = this.database.query(tableName, null, columnName + " = ?", new String[]{primaryKeyData.toString()}, null, null, null);
        return CursorOperation.tryOnCursor(cursor, new CursorOperation<List<Number>>(){

            @Override
            public List<Number> execute(Cursor cursor) throws Exception {
                LinkedList<Number> ids = new LinkedList<Number>();
                while (cursor.moveToNext()) {
                    ids.add(cursor.getLong(foreignAttribute.columnIndex()));
                }
                return ids;
            }
        });
    }

    private static Object getDeclaration(Class<?> associationsDeclaration, Field associationField) {
        return Utilities.getStaticFieldValue(associationsDeclaration, associationField.getName().toUpperCase(Locale.US));
    }
}

