/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.droitateddb.CursorOperation;
import org.droitateddb.EntityData;
import org.droitateddb.SchemaUtil;
import org.droitateddb.Utilities;

class DatabaseSaver {
    private final SQLiteDatabase database;
    private final Map<Object, Number> idsInGraph;
    private final int maxDepth;
    private final Collection<Object> newObjects;
    private final Collection<Object> newUnsavedObjects;
    private final Collection<ToManyUpdate> toManyUpdates;
    private final Map<Object, Collection<ToOneUpdate>> toOneUpdaters;

    public DatabaseSaver(SQLiteDatabase database, int maxDepth) {
        this.database = database;
        this.maxDepth = maxDepth;
        this.idsInGraph = new HashMap<Object, Number>();
        this.newUnsavedObjects = new HashSet<Object>();
        this.newObjects = new HashSet<Object>();
        this.toOneUpdaters = new HashMap<Object, Collection<ToOneUpdate>>();
        this.toManyUpdates = new ArrayList<ToManyUpdate>();
    }

    public Number save(Object data) {
        if (this.idsInGraph.containsKey(data)) {
            return this.idsInGraph.get(data);
        }
        Number id = this.save(data, 0);
        this.performPendingToOneUpdates();
        this.performToManyUpdates();
        return id;
    }

    private Number save(Object data, int currentDepth) {
        if (this.idsInGraph.containsKey(data)) {
            return this.idsInGraph.get(data);
        }
        EntityData entityData = EntityData.getEntityData(data);
        Number id = Utilities.getPrimaryKey(data, entityData);
        if (id != null) {
            this.idsInGraph.put(data, id);
            ContentValues contentValuesForeignKeys = this.collectToOneAssociatedValuesAndSaveAssociatedObjects(data, entityData, currentDepth);
            ContentValues contentValuesEntity = this.getFieldContent(data, entityData);
            if (contentValuesForeignKeys.size() > 0) {
                contentValuesEntity.putAll(contentValuesForeignKeys);
            }
            this.update(id, data.getClass(), entityData, contentValuesEntity);
        } else {
            if (!entityData.autoIncrement) {
                throw new IllegalStateException("PrimaryKey must not be null since " + entityData.type.getName() + " specifies @AutoIncrement. Object has no PrimaryKey: " + data.toString());
            }
            this.newUnsavedObjects.add(data);
            this.newObjects.add(data);
            ContentValues contentValuesForeignKeys = this.collectToOneAssociatedValuesAndSaveAssociatedObjects(data, entityData, currentDepth);
            ContentValues contentValuesEntity = this.getFieldContent(data, entityData);
            if (contentValuesForeignKeys.size() > 0) {
                contentValuesEntity.putAll(contentValuesForeignKeys);
            }
            id = this.insert(data.getClass(), contentValuesEntity);
            this.idsInGraph.put(data, id);
            Utilities.setFieldValue(entityData.primaryKey, data, this.castToIdType(entityData.primaryKey, id));
            this.newUnsavedObjects.remove(data);
        }
        this.saveToManyAssociatedObjects(data, currentDepth, entityData, id);
        return id;
    }

    private Object castToIdType(Field primaryKey, Number id) {
        if (primaryKey.getType().equals(Integer.class)) {
            return id.intValue();
        }
        return id;
    }

    private void performPendingToOneUpdates() {
        for (Map.Entry<Object, Collection<ToOneUpdate>> entry : this.toOneUpdaters.entrySet()) {
            this.updateToOneAssos(entry.getKey(), entry.getValue());
        }
        this.toOneUpdaters.clear();
    }

    private void performToManyUpdates() {
        HashSet<ToManyUpdate> toUpdate = new HashSet<ToManyUpdate>();
        for (ToManyUpdate toManyUpdate : this.toManyUpdates) {
            toManyUpdate.loadIdIfNecessary();
            toUpdate.add(toManyUpdate);
        }
        for (ToManyUpdate toManyUpdate : toUpdate) {
            toManyUpdate.perform();
        }
        this.toManyUpdates.clear();
    }

    private ContentValues collectToOneAssociatedValuesAndSaveAssociatedObjects(Object data, EntityData entityData, int currentDepth) {
        ContentValues contentValuesForeignKeys = new ContentValues(0);
        if (currentDepth >= this.maxDepth) {
            if (entityData.autoIncrement) {
                return contentValuesForeignKeys;
            }
            return this.resolveExistingForeignKeyValues(data, entityData);
        }
        for (Field toOneAssociatedField : entityData.toOneAssociations) {
            Object associatedObject = Utilities.getFieldValue(data, toOneAssociatedField);
            if (associatedObject != null) {
                if (this.newUnsavedObjects.contains(associatedObject)) {
                    Collection<ToOneUpdate> collection = this.toOneUpdaters.get(data);
                    if (collection == null) {
                        collection = new ArrayList<ToOneUpdate>();
                        this.toOneUpdaters.put(data, collection);
                    }
                    collection.add(new ToOneUpdate("fk_" + toOneAssociatedField.getName(), associatedObject));
                    continue;
                }
                Number associationId = this.save(associatedObject, currentDepth + 1);
                contentValuesForeignKeys.put("fk_" + toOneAssociatedField.getName(), associationId.toString());
                continue;
            }
            contentValuesForeignKeys.putNull("fk_" + toOneAssociatedField.getName());
        }
        return contentValuesForeignKeys;
    }

    private ContentValues resolveExistingForeignKeyValues(Object data, EntityData entityData) {
        if (entityData.toOneAssociations.isEmpty()) {
            return new ContentValues();
        }
        String tableName = SchemaUtil.getTableName(entityData.type);
        final String[] projection = new String[entityData.toOneAssociations.size()];
        int i = 0;
        for (Field toOneAssociatedField : entityData.toOneAssociations) {
            projection[i++] = "fk_" + toOneAssociatedField.getName();
        }
        Cursor cursor = this.database.query(tableName, projection, entityData.primaryKey.getName() + " = ?", new String[]{Utilities.getPrimaryKey(data, entityData).toString()}, null, null, null);
        return CursorOperation.tryOnCursor(cursor, new CursorOperation<ContentValues>(){

            @Override
            public ContentValues execute(Cursor cursor) {
                ContentValues values = new ContentValues();
                if (cursor.moveToFirst()) {
                    for (int i = 0; i < cursor.getColumnCount(); ++i) {
                        if (cursor.isNull(i)) continue;
                        values.put(projection[i], Long.valueOf(cursor.getLong(i)));
                    }
                }
                return values;
            }
        });
    }

    private void saveToManyAssociatedObjects(Object data, int currentDepth, EntityData entityData, Number id) {
        if (currentDepth >= this.maxDepth) {
            return;
        }
        for (Field associationField : entityData.toManyAssociations) {
            Collection<?> associatedData = this.getAssociatedData(data, associationField);
            Class<?> dataClass = data.getClass();
            Class<?> linkTableSchema = SchemaUtil.getToManyAsso(associationField, SchemaUtil.getAssociationsSchema(dataClass)).getLinkTableSchema();
            Set<Object> idsFromLinkTable = this.newObjects.contains(data) ? Collections.emptySet() : this.loadIdsFromLinkTable(id, linkTableSchema);
            for (Object obj : associatedData) {
                if (this.newUnsavedObjects.contains(obj)) {
                    this.toManyUpdates.add(new ToManyUpdate(this.database, id, obj, linkTableSchema, ToManyUpdate.Mode.INSERT));
                    continue;
                }
                Number associatedId = this.save(obj, currentDepth + 1);
                if (associatedId instanceof Integer) {
                    associatedId = associatedId.longValue();
                }
                if (!idsFromLinkTable.remove(associatedId)) {
                    this.toManyUpdates.add(new ToManyUpdate(this.database, id, associatedId, linkTableSchema, ToManyUpdate.Mode.INSERT));
                    continue;
                }
                this.toManyUpdates.add(new ToManyUpdate(this.database, id, associatedId, linkTableSchema, ToManyUpdate.Mode.UPDATE));
            }
            if (idsFromLinkTable.isEmpty()) continue;
            for (Number number : idsFromLinkTable) {
                ToManyUpdate toManyUpdateDelete = new ToManyUpdate(this.database, id, number, linkTableSchema, ToManyUpdate.Mode.DELETE);
                if (this.toManyUpdates.contains(toManyUpdateDelete)) continue;
                this.toManyUpdates.add(toManyUpdateDelete);
            }
        }
    }

    private Collection<?> getAssociatedData(Object data, Field associationField) {
        associationField.setAccessible(true);
        Object association = Utilities.getFieldValue(data, associationField);
        if (association != null) {
            return (Collection)Utilities.getFieldValue(data, associationField);
        }
        return Collections.emptyList();
    }

    private ContentValues getFieldContent(Object data, EntityData entityData) {
        ContentValues contentValuesEntity = new ContentValues(entityData.columns.size());
        for (Field column : entityData.columns) {
            this.put(contentValuesEntity, column, data);
        }
        return contentValuesEntity;
    }

    private Set<Long> loadIdsFromLinkTable(Number primaryKeyData, Class<?> linkTableSchema) {
        String tableName = Utilities.getLinkTableName(linkTableSchema);
        String[] projection = Utilities.getLinkTableProjection(linkTableSchema);
        Cursor cursor = this.database.query(tableName, new String[]{projection[1]}, projection[0] + " = ?", new String[]{primaryKeyData.toString()}, null, null, null);
        return CursorOperation.tryOnCursor(cursor, new CursorOperation<Set<Long>>(){

            @Override
            public Set<Long> execute(Cursor cursor) {
                HashSet<Long> ids = new HashSet<Long>();
                while (cursor.moveToNext()) {
                    ids.add(cursor.getLong(0));
                }
                return ids;
            }
        });
    }

    private void put(ContentValues contentValues, Field column, Object data) {
        column.setAccessible(true);
        Class<?> columnType = column.getType();
        String columnName = column.getName();
        Object columnValue = Utilities.getFieldValue(data, column);
        if (columnValue == null) {
            contentValues.putNull(columnName);
        } else if (String.class.equals(columnType)) {
            contentValues.put(columnName, (String)String.class.cast(columnValue));
        } else if (Integer.class.equals(columnType) || Integer.TYPE.equals(columnType)) {
            contentValues.put(columnName, (Integer)Integer.class.cast(columnValue));
        } else if (Float.class.equals(columnType) || Float.TYPE.equals(columnType)) {
            contentValues.put(columnName, (Float)Float.class.cast(columnValue));
        } else if (Double.class.equals(columnType) || Double.TYPE.equals(columnType)) {
            contentValues.put(columnName, (Double)Double.class.cast(columnValue));
        } else if (Long.class.equals(columnType) || Long.TYPE.equals(columnType)) {
            contentValues.put(columnName, (Long)Long.class.cast(columnValue));
        } else if (Boolean.class.equals(columnType) || Boolean.TYPE.equals(columnType)) {
            contentValues.put(columnName, Integer.valueOf((Boolean)Boolean.class.cast(columnValue) != false ? 1 : 0));
        } else if (byte[].class.equals(columnType)) {
            contentValues.put(columnName, (byte[])byte[].class.cast(columnValue));
        } else if (Date.class.equals(columnType)) {
            contentValues.put(columnName, Long.valueOf(((Date)Date.class.cast(columnValue)).getTime()));
        }
    }

    private void updateToOneAssos(Object key, Collection<ToOneUpdate> updates) {
        ContentValues values = new ContentValues();
        for (ToOneUpdate toOneUpdate : updates) {
            values.putAll(toOneUpdate.getContentValues());
        }
        EntityData entityData = EntityData.getEntityData(key);
        this.update(Utilities.getPrimaryKey(key, entityData), key.getClass(), entityData, values);
    }

    private void update(Number id, Class<?> entityClass, EntityData entityData, ContentValues contentValues) {
        if (entityData.autoIncrement) {
            this.database.update(entityClass.getSimpleName(), contentValues, entityData.primaryKey.getName() + " = ?", new String[]{id.toString()});
        } else {
            this.database.insertWithOnConflict(entityClass.getSimpleName(), null, contentValues, 5);
        }
    }

    private long insert(Class<?> entityClass, ContentValues contentValues) {
        return this.database.insertOrThrow(entityClass.getSimpleName(), null, contentValues);
    }

    private static final class ToManyUpdate {
        private Object associated;
        private final SQLiteDatabase database;
        private final String firstColumn;
        private Number firstId;
        private final String linkTableName;
        private final Mode mode;
        private final String secondColumn;
        private Number secondId;

        public ToManyUpdate(SQLiteDatabase database, Number id, Number associatedId, Class<?> linkTableSchema, Mode mode) {
            this.database = database;
            this.mode = mode;
            this.linkTableName = Utilities.getLinkTableName(linkTableSchema);
            String[] projection = Utilities.getLinkTableProjection(linkTableSchema);
            this.firstColumn = projection[0];
            this.secondColumn = projection[1];
            this.firstId = id;
            this.secondId = associatedId;
        }

        public ToManyUpdate(SQLiteDatabase database, Number id, Object associated, Class<?> linkTableSchema, Mode mode) {
            this(database, id, null, linkTableSchema, mode);
            this.associated = associated;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof ToManyUpdate && this.hashCode() == o.hashCode();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.firstId == null ? 0 : this.firstId.intValue());
            result = 31 * result + (this.linkTableName == null ? 0 : this.linkTableName.hashCode());
            result = 31 * result + (this.secondId == null ? 0 : this.secondId.intValue());
            return result;
        }

        public void loadIdIfNecessary() {
            if (this.associated != null) {
                Number primaryKey = Utilities.getPrimaryKey(this.associated, EntityData.getEntityData(this.associated));
                if (this.firstId == null) {
                    this.firstId = primaryKey;
                } else {
                    this.secondId = primaryKey;
                }
            }
        }

        public void perform() {
            switch (this.mode) {
                case INSERT: {
                    ContentValues contentValues = new ContentValues(2);
                    contentValues.put(this.firstColumn, this.firstId.toString());
                    contentValues.put(this.secondColumn, this.secondId.toString());
                    this.database.insertOrThrow(this.linkTableName, null, contentValues);
                    break;
                }
                case DELETE: {
                    this.database.delete(this.linkTableName, this.firstColumn + "= ? AND " + this.secondColumn + "=?", new String[]{this.firstId.toString(), this.secondId.toString()});
                    break;
                }
                case UPDATE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported case: " + (Object)((Object)this.mode));
                }
            }
        }

        private static enum Mode {
            DELETE,
            INSERT,
            UPDATE;

        }
    }

    private static final class ToOneUpdate {
        private final Object associatedObject;
        private final String foreignkey;

        ToOneUpdate(String foreignkey, Object associatedObject) {
            this.foreignkey = foreignkey;
            this.associatedObject = associatedObject;
        }

        ContentValues getContentValues() {
            ContentValues contentValuesForeignKey = new ContentValues(1);
            contentValuesForeignKey.put(this.foreignkey, Utilities.getPrimaryKey(this.associatedObject, EntityData.getEntityData(this.associatedObject)).toString());
            return contentValuesForeignKey;
        }
    }
}

