/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.droitateddb.Utilities;
import org.droitateddb.entity.Relationship;

public class FlatEntityParcelable<E>
implements Parcelable {
    private final E data;
    private final Field[] fields;
    private static final String SKIPPED = "__##SKIPPED##__";
    public static final Parcelable.Creator<?> CREATOR = new Parcelable.Creator<Object>(){

        public Object createFromParcel(Parcel source) {
            return new FlatEntityParcelable(source);
        }

        public Object[] newArray(int size) {
            return new FlatEntityParcelable[size];
        }
    };

    public FlatEntityParcelable(E data) {
        this.assertNonArgsContructor(data);
        this.data = data;
        this.fields = data.getClass().getDeclaredFields();
    }

    private void assertNonArgsContructor(E data) {
        try {
            data.getClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The given object has to have a non-args constructor");
        }
    }

    public FlatEntityParcelable(Parcel in) {
        String className = in.readString();
        try {
            Class<?> entityClass = Class.forName(className);
            Constructor<?> constructor = entityClass.getConstructor(new Class[0]);
            Object instance = constructor.newInstance(new Object[0]);
            for (Field field : this.fields = entityClass.getDeclaredFields()) {
                Object value = in.readValue(Thread.currentThread().getContextClassLoader());
                if (SKIPPED.equals(value)) continue;
                field.setAccessible(true);
                field.set(instance, value);
            }
            this.data = instance;
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't recreate @Entity from given Parcel data", e);
        }
    }

    public E getEntity() {
        return this.data;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.data.getClass().getCanonicalName());
        for (Field field : this.fields) {
            field.setAccessible(true);
            try {
                if (field.getAnnotation(Relationship.class) == null && this.isPrimitive(field)) {
                    dest.writeValue(Utilities.getFieldValue(this.data, field));
                    continue;
                }
                dest.writeValue((Object)SKIPPED);
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't convert entity into Parcelable", e);
            }
        }
    }

    private boolean isPrimitive(Field field) {
        Class<?> fieldType = field.getType();
        if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
            return true;
        }
        if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
            return true;
        }
        if (fieldType.equals(Character.class) || fieldType.equals(Character.TYPE)) {
            return true;
        }
        if (fieldType.equals(byte[].class)) {
            return true;
        }
        if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
            return true;
        }
        if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
            return true;
        }
        if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
            return true;
        }
        if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
            return true;
        }
        return fieldType.equals(String.class);
    }
}

