/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.droitateddb.Utilities;

final class PersistenceDefinition {
    private final String name;
    private final int version;
    private final ArrayList<String> sqlCreationStatements = new ArrayList();
    private final ArrayList<String> indexStatements = new ArrayList();
    private final Class<?> updateHook;
    private final Class<?> createHook;

    public PersistenceDefinition(String name, int version, Class<?> updateHook, Class<?> createHook, List<String> sqlCreationStatements, List<String> indexStatements) {
        this.name = name;
        this.version = version;
        this.updateHook = updateHook;
        this.createHook = createHook;
        this.sqlCreationStatements.addAll(sqlCreationStatements);
        this.indexStatements.addAll(indexStatements);
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public Class<?> getUpdateHook() {
        return this.updateHook;
    }

    public Class<?> getCreateHook() {
        return this.createHook;
    }

    public List<String> getSqlCreationStatements() {
        return Collections.unmodifiableList(this.sqlCreationStatements);
    }

    public List<String> getIndexStatements() {
        return Collections.unmodifiableList(this.indexStatements);
    }

    public static PersistenceDefinition create(String basePackage) {
        return PersistenceDefinition.loadPersistenceData(basePackage);
    }

    private static PersistenceDefinition loadPersistenceData(String basePackage) {
        try {
            Class<?> schemaClass = Class.forName(basePackage + "." + "generated" + "." + "DB");
            String dbName = (String)Utilities.getStaticFieldValue(schemaClass, "DB_NAME");
            int dbVersion = (Integer)Utilities.getStaticFieldValue(schemaClass, "DB_VERSION");
            Class<?> updateHook = PersistenceDefinition.getHook(schemaClass, "DB_UPDATE_HOOK");
            Class<?> createHook = PersistenceDefinition.getHook(schemaClass, "DB_CREATE_HOOK");
            Class<?>[] tableDefinitions = schemaClass.getDeclaredClasses();
            ArrayList<String> creationStatements = new ArrayList<String>(tableDefinitions.length);
            ArrayList<String> indexStatements = new ArrayList<String>(tableDefinitions.length);
            for (Class<?> def : tableDefinitions) {
                Field[] allFields;
                if (!def.isInterface() || !def.getSimpleName().endsWith("Table") && !def.getSimpleName().endsWith("Association")) continue;
                String statement = (String)Utilities.getStaticFieldValue(def, "SQL_CREATION");
                creationStatements.add(statement);
                for (Field field : allFields = def.getDeclaredFields()) {
                    if (!field.getName().startsWith("SQL_INDEX")) continue;
                    indexStatements.add((String)Utilities.getStaticFieldValue(field));
                }
            }
            return new PersistenceDefinition(dbName, dbVersion, updateHook, createHook, creationStatements, indexStatements);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't parse persistence data from DB class", e);
        }
    }

    private static Class<?> getHook(Class<?> schemaClass, String hookName) {
        Class<?> hook = null;
        try {
            Field hookField = Utilities.getDeclaredField(schemaClass, hookName);
            if (hookField != null) {
                String className = (String)Utilities.getStaticFieldValue(hookField);
                hook = Class.forName(className);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hook;
    }
}

