/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import java.lang.reflect.Field;
import org.droitateddb.EntityData;
import org.droitateddb.schema.AbstractAttribute;

public class Utilities {
    public static RuntimeException handle(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    static void setFieldValue(Field field, Object data, Object value) {
        try {
            field.setAccessible(true);
            field.set(data, value);
        }
        catch (IllegalAccessException e) {
            throw Utilities.handle(e);
        }
    }

    static String getLinkTableName(Class<?> linkTableSchema) {
        return (String)Utilities.getStaticFieldValue(linkTableSchema, "TABLE_NAME");
    }

    static AbstractAttribute[] getLinkTableColumns(Class<?> linkTableSchema) {
        return (AbstractAttribute[])Utilities.getStaticFieldValue(linkTableSchema, "ATTRIBUTES");
    }

    static String[] getLinkTableProjection(Class<?> linkTableSchema) {
        return (String[])Utilities.getStaticFieldValue(linkTableSchema, "PROJECTION");
    }

    static Number getPrimaryKey(Object data, EntityData entityData) {
        return (Number)Utilities.getFieldValue(data, entityData.primaryKey);
    }

    public static <T> T getStaticFieldValue(Class<?> aClass, String fieldName) {
        return Utilities.getStaticFieldValue(Utilities.getDeclaredField(aClass, fieldName));
    }

    static <T> T getFieldValue(Class<?> aClass, String fieldName, Object data) {
        return Utilities.getFieldValue(data, Utilities.getDeclaredField(aClass, fieldName));
    }

    public static Field getDeclaredField(Class<?> aClass, String fieldName) {
        try {
            return aClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            Field[] declaredFields;
            for (Field field : declaredFields = aClass.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            throw Utilities.handle(nsfe);
        }
    }

    static <T> T getStaticFieldValue(Field field) {
        return Utilities.getFieldValue(null, field);
    }

    static <T> T getFieldValue(Object data, Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(data);
        }
        catch (IllegalAccessException e) {
            throw Utilities.handle(e);
        }
    }
}

