/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.data;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.droitateddb.builder.schema.data.Association;
import org.droitateddb.builder.schema.data.Column;

public class Table {
    private final String name;
    private final String entityClassName;
    private final Set<Column> columns = new TreeSet<Column>(new Comparator<Column>(){

        @Override
        public int compare(Column c1, Column c2) {
            return c1.getNameInEntity().compareTo(c2.getNameInEntity());
        }
    });
    private final Set<Association> associations = new TreeSet<Association>(new Comparator<Association>(){

        @Override
        public int compare(Association a1, Association a2) {
            return a1.getNameInEntity().compareTo(a2.getNameInEntity());
        }
    });

    public Table(String name, String entityClassName) {
        this.name = name;
        this.entityClassName = entityClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public Set<Column> getColumns() {
        return Collections.unmodifiableSet(this.columns);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public Set<Association> getAssociations() {
        return Collections.unmodifiableSet(this.associations);
    }

    public void addAssociation(Association association) {
        this.associations.add(association);
    }
}

