/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.reader;

import javax.annotation.processing.Messager;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.droitateddb.builder.schema.data.Column;
import org.droitateddb.builder.schema.data.ColumnValidation;
import org.droitateddb.builder.schema.reader.ColumnValidationReader;
import org.droitateddb.builder.schema.reader.Reader;
import org.droitateddb.entity.AutoIncrement;
import org.droitateddb.entity.PrimaryKey;
import org.droitateddb.schema.ColumnType;

public class ColumnReader
implements Reader<Column> {
    private final VariableElement column;
    private final Elements elements;
    private final Messager messager;

    public ColumnReader(VariableElement column, Elements elements, Messager messager) {
        this.column = column;
        this.elements = elements;
        this.messager = messager;
    }

    @Override
    public Column read() {
        String nameInEntity = this.column.getSimpleName().toString();
        String typeInEntity = this.column.asType().toString();
        try {
            boolean isPrimaryKey = this.isPrimaryKeyAnnotated(this.column);
            boolean isAutoincrementing = this.isAutoIncrementAnnotated(this.column);
            this.checkPrimaryKeyAndAutoincrementLocation(isPrimaryKey, isAutoincrementing, this.column, typeInEntity);
            ColumnValidation columnValidation = new ColumnValidationReader(this.column, this.elements, this.messager).read();
            return new Column(nameInEntity, typeInEntity, ColumnType.resolveColumnType(typeInEntity), isPrimaryKey, isAutoincrementing, columnValidation);
        }
        catch (IllegalStateException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), this.column);
            return null;
        }
    }

    private boolean isPrimaryKeyAnnotated(VariableElement variableElement) {
        return variableElement.getAnnotation(PrimaryKey.class) != null;
    }

    private boolean isAutoIncrementAnnotated(VariableElement variableElement) {
        return variableElement.getAnnotation(AutoIncrement.class) != null;
    }

    private void checkPrimaryKeyAndAutoincrementLocation(boolean hasPrimaryKey, boolean hasAutoIncrement, VariableElement variableElement, String fieldType) {
        if (!hasPrimaryKey && hasAutoIncrement) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@AutoIncrement is only allowed for @PrimaryKey fields", variableElement);
        } else if (hasPrimaryKey && this.fieldIsNotAWholeNumber(fieldType)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@PrimaryKey is only allowed for non-primitiv whole-numbers", variableElement);
        }
    }

    private boolean fieldIsNotAWholeNumber(String fieldType) {
        return !Integer.class.getCanonicalName().equals(fieldType) && !Long.class.getCanonicalName().equals(fieldType);
    }
}

